package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiContentAdvisory;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiContentAdvisoryConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiContentAdvisoryConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

/**
 * DataProvider for Content Advisory table
 */
public class ContentAdvisoryDataProvider implements DataProvider<String, UiContentAdvisoryRecord> {
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	private UiContentAdvisoryConfigServiceAsync service = GWT.create(UiContentAdvisoryConfigService.class);
	private Table<String, UiContentAdvisoryRecord> table;
	private List<Column<?, UiContentAdvisoryRecord>> columns = null;
	private MetadataConfigLazyView view = null;
	
	private String lastColumnName = "";
	private SortOrder lastSortOrder = SortOrder.ASCENDING;

	private ContentAdvisoryConfigTab tab;

	public ContentAdvisoryDataProvider(MetadataConfigLazyView view, ContentAdvisoryConfigTab tab) {
		this.tab = tab;
		this.view = view;
	}
	
	@Override
	public List<Column<?, UiContentAdvisoryRecord>> getColumns() {
		if (columns != null)
			return columns;
	
		columns = new ArrayList<Column<?,UiContentAdvisoryRecord>>();
		
		columns.add(new ColumnBase<UiContentAdvisoryRecord, UiContentAdvisoryRecord>("ADVISORY", myConstants.caColumnHeadingContentAdvisory()) {
			@Override
			public View<UiContentAdvisoryRecord> getView(final UiContentAdvisoryRecord record) {
				return new View<UiContentAdvisoryRecord>() {
					@Override
					public void release() {
						//Nothing to do here
					}
				
					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getContentAdvisoryDisplay());
						label.setTitle(record.getContentAdvisory().getContentAdvisory());
						return label;
					}
				
					@Override
					public String getStyleName() {
						return null;
					}
				};
			}
		});
		
		columns.add(new ColumnBase<UiContentAdvisoryRecord, UiContentAdvisoryRecord>("DESCRIPTION", myConstants.caColumnHeadingDescription()) {
			@Override
			public View<UiContentAdvisoryRecord> getView(final UiContentAdvisoryRecord record) {
				return new View<UiContentAdvisoryRecord>() {
					@Override
					public void release() {
						//Nothing to do here
					}
				
					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getDescriptionDisplay());
						label.setTitle(record.getContentAdvisory().getDescription());
						return label;
					}
				
					@Override
					public String getStyleName() {
						return null;
					}
				};
			}
		});
		
		return columns;
	}

	@Override
	public void getRecord(String key, AsyncCallback<UiContentAdvisoryRecord> callback) {
		callback.onSuccess(null);
	}

	@Override
	public void getRecords(final AsyncCallback<List<UiContentAdvisoryRecord>> callback) {
		String columnName = table.getSortFeature().getSortColumn().getName();
		SortOrder sortOrder = table.getSortFeature().getSortOrder();
		
		if (!columnName.equalsIgnoreCase(lastColumnName) || !sortOrder.equals(lastSortOrder)) {
			if (tab != null) {
				tab.clearErrors();
			}
		}
		lastColumnName = columnName;
		lastSortOrder = sortOrder;
		view.showBusyIndicator();
		
		service.getAllContentAdvisories(columnName, (sortOrder.equals(SortOrder.DESCENDING) ? true : false), new NeptuneAsyncCallback<List<UiContentAdvisory>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				if (tab != null) {
					tab.setError(caught.getMessage());
				}
//				callback.onFailure(caught);
				callback.onFailure(null);
				view.hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(List<UiContentAdvisory> result) {
				callback.onSuccess(convertRecords(result));
				view.hideBusyIndicator();
			}
		});
	}

	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	@Override
	public boolean isCheckboxEnabled() {
		return true;
	}

	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}

	private List<UiContentAdvisoryRecord> convertRecords(List<UiContentAdvisory> results) {
		List<UiContentAdvisoryRecord> retVal = new ArrayList<UiContentAdvisoryRecord>();
		for (UiContentAdvisory item : results) {
			retVal.add(new UiContentAdvisoryRecord(item));
		}
		return retVal;
	}

	public void setTable(Table<String, UiContentAdvisoryRecord> table) {
		this.table = table;
	}
}
