package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.contentadvisory;

import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiContentAdvisory;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Record wrapper for <UiContentAdvisory>
 * The ...Display() methods are used to make sure the data displayed in table columns does not exceed a predefined length. 
 * Data exceeding limit is chopped off and shown as a continuation mark '...' at the end. A tool tip displays complete data.
 */
public class UiContentAdvisoryRecord implements Record<String> {
	private final UiContentAdvisory contentAdvisory;
	
	public UiContentAdvisoryRecord(UiContentAdvisory contentAdvisory) {
		this.contentAdvisory = contentAdvisory;
	}
	
	@Override
	public String getKey() {
		return contentAdvisory.getContentAdvisory();
	}

	public UiContentAdvisory getContentAdvisory() {
		return contentAdvisory;
	}

	public String getContentAdvisoryDisplay() {
		String retVal = contentAdvisory.getContentAdvisory();
		if (retVal != null && retVal.length() > MetadataConfigConstants.ID_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.ID_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}
	
	public String getDescriptionDisplay() {
		String retVal = contentAdvisory.getDescription();
		if (retVal != null && retVal.length() > MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}
}
