package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiGenre;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiGenreConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiGenreConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class GenreConfigController implements IMetadataConfigController<UiGenre> {
	private UiGenreConfigServiceAsync service = GWT.create(UiGenreConfigService.class);
	private MetadataConfigTab<UiGenre, String, UiGenreRecord> tab;
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	public GenreConfigController(MetadataConfigTab<UiGenre, String, UiGenreRecord> tab) {
		this.tab = tab;
	}

	@Override
	public void getList() {
		tab.getTable().refresh();
	}
	
	@Override
	public void delete(final List<String> itemIds) {
		tab.getView().showBusyIndicator();
		
		service.deleteGenre(itemIds, new NeptuneAsyncCallback<Boolean>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.getView().hideBusyIndicator();
				tab.setError(caught.getMessage());
			}

			@Override
			public void onNeptuneSuccess(Boolean result) {
				tab.getView().hideBusyIndicator();
				if (result) {
					tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(myConstants.genreTabName(), tab.getCommaSeparatedList(itemIds)));
				} else {
					tab.setError(myConstants.deleteFailed());
					return;
				}
				getList();
			}
		});
	}

	@Override
	public void get(String... ids) {
		if (ids.length != 1) {
			//TODO: set error on UI
			return;
		}
		
		tab.getView().showBusyIndicator();
		
		service.getGenre(ids[0], new NeptuneAsyncCallback<UiGenre>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				//TODO: set error on UI
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiGenre result) {
				//TODO: show content on edit screen
				tab.getView().hideBusyIndicator();
			}
		});
	}


	@Override
	public void update(final UiGenre item) {
		tab.getView().showBusyIndicator();
		
		service.updateGenre(item, new NeptuneAsyncCallback<UiGenre>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.setError(caught.getMessage());
				tab.refreshCreateView(item);
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiGenre result) {
				tab.refreshCreateView(null);
				tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(myConstants.genreTabName(), item.getGenre()));
				tab.getView().hideBusyIndicator();
				getList();
				tab.showListPanel();
			}
			
		});
	}
}
