package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.i18n.client.HasDirection.Direction;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiGenre;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

public class GenreConfigTab extends MetadataConfigTab<UiGenre, String, UiGenreRecord> {

	private boolean createViewInitialized = false;
	private TextBox genreTxt = null;
	private TextArea descriptionTxt = null;
	
	public GenreConfigTab(MetadataConfigLazyView view) {
		super(view);
	}
	
	@Override
	protected void createController() {
		controller = new GenreConfigController(this);
	}

	@Override
	public void refreshCreateView(UiGenre item) {
		if (ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE)) {
			if (!createViewInitialized) {
				FormContainer form = new FormContainer(HorizontalAlignmentConstant.endOf(Direction.DEFAULT));
				genreTxt = new TextBox();
				genreTxt.addStyleName(TEXT_BOX_SHORT_STYLE);
				form.addRow(new LabelWidget(constants.gColumnHeadingGenre()), genreTxt, true);
				descriptionTxt = new TextArea();
				descriptionTxt.addStyleName(TEXT_AREA_STYLE);
				form.addRow(new LabelWidget(constants.gColumnHeadingDescription()), descriptionTxt, false);
				createPanel.add(form);
				createViewInitialized = true;
			}
			
			if (item == null) {
				genreTxt.setText("");
				descriptionTxt.setText("");
			} else {
				genreTxt.setText(item.getGenre() == null ? "" : item.getGenre());
				descriptionTxt.setText(item.getDescription() == null ? "" : item.getDescription());
			}
		}
	}

	@Override
	protected Table<String, UiGenreRecord> createTable() {
		GenreDataProvider dataProvider = new GenreDataProvider(view, this);
		Table<String, UiGenreRecord> tbl = new Table<String, UiGenreRecord>(dataProvider);
		dataProvider.setTable(tbl);
		List<Column<?, UiGenreRecord>> columns = dataProvider.getColumns();
		SortFeature<String, UiGenreRecord> sortFeature = new SortFeatureImpl<String, UiGenreRecord>(columns.get(0), SortOrder.ASCENDING);
		sortFeature.getSortableColumns().addAll(columns);
		tbl.addSortFeature(sortFeature);
		tbl.initialize(null);
		return tbl;
	}

	@Override
	public void delete(List<UiGenreRecord> selectedIds) {
		if(Window.confirm(constants.confirmDelete())) {
			List<String> itemIds = new ArrayList<String>();
			for (UiGenreRecord id : selectedIds) {
				itemIds.add(id.getKey());
			}
			controller.delete(itemIds);
		}
	}

	private String validateInput() {
		String genre = genreTxt.getText();
		if (isBlank(genre)) {
			return constants.errBlankGenre();
		}
		if (genre.trim().length() > 64) {
			return constants.errGenreTooLong();
		}
		String description = descriptionTxt.getText();
		if (!isBlank(description) && description.trim().length() > 255) {
			return constants.errDescriptionTooLong();
		}
		return "";
	}

	@Override
	public void save() {
		String err = validateInput();
		if (err.length() > 0) {
			setError(err);
			return;
		}
		clearErrors();
		if (controller != null) {
			UiGenre genre = new UiGenre();
			genre.setGenre(genreTxt.getText().trim());
			genre.setDescription(descriptionTxt.getText().trim());
			controller.update(genre);
		}		
	}

}
