package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiGenre;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiGenreConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiGenreConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

/**
 * DataProvider for Genre table
 */
public class GenreDataProvider implements DataProvider<String, UiGenreRecord> {
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	private UiGenreConfigServiceAsync service = GWT.create(UiGenreConfigService.class);
	private Table<String, UiGenreRecord> table;
	private List<Column<?, UiGenreRecord>> columns = null;
	private MetadataConfigLazyView view = null;
	
	private String lastColumnName = "";
	private SortOrder lastSortOrder = SortOrder.ASCENDING;

	private GenreConfigTab tab;

	public GenreDataProvider(MetadataConfigLazyView view, GenreConfigTab tab) {
		this.tab = tab;
		this.view = view;
	}

	@Override
	public List<Column<?, UiGenreRecord>> getColumns() {
		if (columns != null)
			return columns;
		
		columns = new ArrayList<Column<?,UiGenreRecord>>();
		
		columns.add(new ColumnBase<UiGenreRecord, UiGenreRecord>("GENRE", myConstants.gColumnHeadingGenre()) {
			@Override
			public View<UiGenreRecord> getView(final UiGenreRecord record) {
				return new View<UiGenreRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getGenreDisplay());
						label.setTitle(record.getGenre().getGenre());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
					
				};
			}
		});
		
		columns.add(new ColumnBase<UiGenreRecord, UiGenreRecord>("DESCRIPTION", myConstants.gColumnHeadingDescription()){
			@Override
			public View<UiGenreRecord> getView(final UiGenreRecord record) {
				return new View<UiGenreRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getDescriptionDisplay());
						label.setTitle(record.getGenre().getDescription());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
				};
			}
		});

		return columns;
	}

	@Override
	public void getRecord(String key, AsyncCallback<UiGenreRecord> callback) {
		callback.onSuccess(null);
	}

	@Override
	public void getRecords(final AsyncCallback<List<UiGenreRecord>> callback) {
		String columnName = table.getSortFeature().getSortColumn().getName();
		SortOrder sortOrder = table.getSortFeature().getSortOrder();
		
		if (!columnName.equalsIgnoreCase(lastColumnName) || !sortOrder.equals(lastSortOrder)) {
			if (tab != null) {
				tab.clearErrors();
			}
		}
		lastColumnName = columnName;
		lastSortOrder = sortOrder;
		view.showBusyIndicator();
		
		service.getAllGenre(columnName, (sortOrder.equals(SortOrder.DESCENDING) ? true : false), new NeptuneAsyncCallback<List<UiGenre>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				if (tab != null) {
					tab.setError(caught.getMessage());
				}
//				callback.onFailure(caught);
				callback.onFailure(null);
				view.hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(List<UiGenre> result) {
				callback.onSuccess(convertRecords(result));
				view.hideBusyIndicator();
			}
		});
	}

	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	@Override
	public boolean isCheckboxEnabled() {
		return true;
	}

	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}
	
	private List<UiGenreRecord> convertRecords(List<UiGenre> results) {
		List<UiGenreRecord> retVal = new ArrayList<UiGenreRecord>();
		for (UiGenre item : results) {
			retVal.add(new UiGenreRecord(item));
		}
		return retVal;
	}
	
	public void setTable(Table<String, UiGenreRecord> table) {
		this.table = table;
	}
}
