package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.genre;

import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiGenre;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Record wrapper for <UiGenre>
 * The ...Display() methods are used to make sure the data displayed in table columns does not exceed a predefined length. 
 * Data exceeding limit is chopped off and shown as a continuation mark '...' at the end. A tool tip displays complete data.
 */
public class UiGenreRecord implements Record<String> {
	private final UiGenre genre;
	
	public UiGenreRecord(UiGenre genre) {
		this.genre = genre;
	}

	@Override
	public String getKey() {
		return genre.getGenre();
	}

	public UiGenre getGenre() {
		return genre;
	}
	
	public String getGenreDisplay() {
		String retVal = genre.getGenre();
		if (retVal != null && retVal.length() > MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}

	public String getDescriptionDisplay() {
		String retVal = genre.getDescription();
		if (retVal != null && retVal.length() > MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}
}
