package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiProduct;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiProductConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiProductConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class ProductConfigController implements IMetadataConfigController<UiProduct> {
	private UiProductConfigServiceAsync service = GWT.create(UiProductConfigService.class);
	private MetadataConfigTab<UiProduct, String, UiProductRecord> tab;
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	public ProductConfigController(MetadataConfigTab<UiProduct, String, UiProductRecord> tab) {
		this.tab = tab;
	}

	@Override
	public void getList() {
		tab.getTable().refresh();
	}
	
	@Override
	public void delete(final List<String> itemIds) {
		tab.getView().showBusyIndicator();
		
		service.deleteProduct(itemIds, new NeptuneAsyncCallback<Boolean>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.getView().hideBusyIndicator();
				tab.setError(caught.getMessage());
			}

			@Override
			public void onNeptuneSuccess(Boolean result) {
				tab.getView().hideBusyIndicator();
				if (result) {
					tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(myConstants.productTabName(), tab.getCommaSeparatedList(itemIds)));
				} else {
					tab.setError(myConstants.deleteFailed());
					return;
				}
				getList();
			}
		});
	}

	@Override
	public void get(String... ids) {
		if (ids.length != 1) {
			//TODO: set error on UI
			return;
		}
		
		tab.getView().showBusyIndicator();
		
		service.getProduct(ids[0], new NeptuneAsyncCallback<UiProduct>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				//TODO: set error on UI
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiProduct result) {
				//TODO: show content on edit screen
				tab.getView().hideBusyIndicator();
			}
		});
	}


	@Override
	public void update(final UiProduct item) {
		tab.getView().showBusyIndicator();
		
		service.updateProduct(item, new NeptuneAsyncCallback<UiProduct>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.setError(caught.getMessage());
				tab.refreshCreateView(item);
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiProduct result) {
				tab.refreshCreateView(null);
				tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(myConstants.productTabName(), item.getProductCode()));
				tab.getView().hideBusyIndicator();
				getList();
				tab.showListPanel();
			}
			
		});
	}
}
