package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.i18n.client.HasDirection.Direction;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiProduct;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

public class ProductConfigTab extends MetadataConfigTab<UiProduct, String, UiProductRecord> {

	private boolean createViewInitialized = false;
	private TextBox productCodeTxt = null;
	private TextArea descriptionTxt = null;
	
	public ProductConfigTab(MetadataConfigLazyView view) {
		super(view);
	}
	
	@Override
	protected void createController() {
		controller = new ProductConfigController(this);
	}

	@Override
	public void refreshCreateView(UiProduct item) {
		if (ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE)) {
			if (!createViewInitialized) {
				FormContainer form = new FormContainer(HorizontalAlignmentConstant.endOf(Direction.DEFAULT));
				productCodeTxt = new TextBox();
				productCodeTxt.addStyleName(TEXT_BOX_SHORT_STYLE);
				form.addRow(new LabelWidget(constants.pColumnHeadingProductCode()), productCodeTxt, true);
				descriptionTxt = new TextArea();
				descriptionTxt.addStyleName(TEXT_AREA_STYLE);
				form.addRow(new LabelWidget(constants.pColumnHeadingDescription()), descriptionTxt, false);
				createPanel.add(form);
				createViewInitialized = true;
			}
			
			if (item == null) {
				productCodeTxt.setText("");
				descriptionTxt.setText("");
			} else {
				productCodeTxt.setText(item.getProductCode() == null ? "" : item.getProductCode());
				descriptionTxt.setText(item.getDescription() == null ? "" : item.getDescription());
			}
		}
	}

	@Override
	protected Table<String, UiProductRecord> createTable() {
		ProductDataProvider dataProvider = new ProductDataProvider(view, this);
		Table<String, UiProductRecord> tbl = new Table<String, UiProductRecord>(dataProvider);
		dataProvider.setTable(tbl);
		List<Column<?, UiProductRecord>> columns = dataProvider.getColumns();
		SortFeature<String, UiProductRecord> sortFeature = new SortFeatureImpl<String, UiProductRecord>(columns.get(0), SortOrder.ASCENDING);
		sortFeature.getSortableColumns().addAll(columns);
		tbl.addSortFeature(sortFeature);
		tbl.initialize(null);
		return tbl;
	}

	@Override
	public void delete(List<UiProductRecord> selectedIds) {
		if(Window.confirm(constants.confirmDelete())) {
			List<String> itemIds = new ArrayList<String>();
			for (UiProductRecord id : selectedIds) {
				itemIds.add(id.getKey());
			}
			controller.delete(itemIds);
		}
	}

	private String validateInput() {
		String productCode = productCodeTxt.getText();
		if (isBlank(productCode)) {
			return constants.errBlankProductCode();
		}
		if (productCode.trim().length() > 64) {
			return constants.errProductCodeTooLong();
		}
		String description = descriptionTxt.getText();
		if (!isBlank(description) && description.trim().length() > 255) {
			return constants.errDescriptionTooLong();
		}
		return "";
	}

	@Override
	public void save() {
		String err = validateInput();
		if (err.length() > 0) {
			setError(err);
			return;
		}
		clearErrors();
		if (controller != null) {
			UiProduct product = new UiProduct();
			product.setProductCode(productCodeTxt.getText().trim());
			product.setDescription(descriptionTxt.getText().trim());
			controller.update(product);
		}		
	}

}
