package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiProduct;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiProductConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiProductConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

/**
 * DataProvider for Product table
 */
public class ProductDataProvider implements DataProvider<String, UiProductRecord> {
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	private UiProductConfigServiceAsync service = GWT.create(UiProductConfigService.class);
	private Table<String, UiProductRecord> table;
	private List<Column<?, UiProductRecord>> columns = null;
	private MetadataConfigLazyView view = null;
	
	private String lastColumnName = "";
	private SortOrder lastSortOrder = SortOrder.ASCENDING;

	private ProductConfigTab tab;

	public ProductDataProvider(MetadataConfigLazyView view, ProductConfigTab tab) {
		this.tab = tab;
		this.view = view;
	}

	@Override
	public List<Column<?, UiProductRecord>> getColumns() {
		if (columns != null)
			return columns;
		
		columns = new ArrayList<Column<?,UiProductRecord>>();
		
		columns.add(new ColumnBase<UiProductRecord, UiProductRecord>("PRODUCTCODE", myConstants.pColumnHeadingProductCode()) {
			@Override
			public View<UiProductRecord> getView(final UiProductRecord record) {
				return new View<UiProductRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getProductCodeDisplay());
						label.setTitle(record.getProduct().getProductCode());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
					
				};
			}
		});
		
		columns.add(new ColumnBase<UiProductRecord, UiProductRecord>("DESCRIPTION", myConstants.pColumnHeadingDescription()){
			@Override
			public View<UiProductRecord> getView(final UiProductRecord record) {
				return new View<UiProductRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getDescriptionDisplay());
						label.setTitle(record.getProduct().getDescription());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
				};
			}
		});

		return columns;
	}

	@Override
	public void getRecord(String key, AsyncCallback<UiProductRecord> callback) {
		callback.onSuccess(null);
	}

	@Override
	public void getRecords(final AsyncCallback<List<UiProductRecord>> callback) {
		String columnName = table.getSortFeature().getSortColumn().getName();
		SortOrder sortOrder = table.getSortFeature().getSortOrder();
		
		if (!columnName.equalsIgnoreCase(lastColumnName) || !sortOrder.equals(lastSortOrder)) {
			if (tab != null) {
				tab.clearErrors();
			}
		}
		lastColumnName = columnName;
		lastSortOrder = sortOrder;
		view.showBusyIndicator();
		
		service.getAllProducts(columnName, (sortOrder.equals(SortOrder.DESCENDING) ? true : false), new NeptuneAsyncCallback<List<UiProduct>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				if (tab != null) {
					tab.setError(caught.getMessage());
				}
//				callback.onFailure(caught);
				callback.onFailure(null);
				view.hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(List<UiProduct> result) {
				callback.onSuccess(convertRecords(result));
				view.hideBusyIndicator();
			}
		});
	}

	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	@Override
	public boolean isCheckboxEnabled() {
		return true;
	}

	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}
	
	private List<UiProductRecord> convertRecords(List<UiProduct> results) {
		List<UiProductRecord> retVal = new ArrayList<UiProductRecord>();
		for (UiProduct item : results) {
			retVal.add(new UiProductRecord(item));
		}
		return retVal;
	}
	
	public void setTable(Table<String, UiProductRecord> table) {
		this.table = table;
	}
}
