package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.product;

import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiProduct;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Record wrapper for <UiProduct>
 * The ...Display() methods are used to make sure the data displayed in table columns does not exceed a predefined length. 
 * Data exceeding limit is chopped off and shown as a continuation mark '...' at the end. A tool tip displays complete data.
 */
public class UiProductRecord implements Record<String> {
	private final UiProduct product;
	
	public UiProductRecord(UiProduct product) {
		this.product = product;
	}

	@Override
	public String getKey() {
		return product.getProductCode();
	}

	public UiProduct getProduct() {
		return product;
	}
	
	public String getProductCodeDisplay() {
		String retVal = product.getProductCode();
		if (retVal != null && retVal.length() > MetadataConfigConstants.ID_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.ID_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}
	
	public String getDescriptionDisplay() {
		String retVal = product.getDescription();
		if (retVal != null && retVal.length() > MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}
}
