package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiRating;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiRatingConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiRatingConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class RatingConfigController implements IMetadataConfigController<UiRating> {
	private UiRatingConfigServiceAsync service = GWT.create(UiRatingConfigService.class);
	private MetadataConfigTab<UiRating, String, UiRatingRecord> tab;
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	public RatingConfigController(MetadataConfigTab<UiRating, String, UiRatingRecord> tab) {
		this.tab = tab;
	}

	@Override
	public void getList() {
		tab.getTable().refresh();
	}
	
	@Override
	public void delete(final List<String> itemIds) {
		tab.getView().showBusyIndicator();
		
		Map<String, String> itemsMap = new HashMap<String, String>();
		for (String item : itemIds) {
			String[] arr = item.split(UiRatingRecord.RATING_ID_SEPARATOR);
			itemsMap.put(arr[0], arr[1]);
		}
		service.deleteRating(itemsMap, new NeptuneAsyncCallback<Boolean>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.getView().hideBusyIndicator();
				tab.setError(caught.getMessage());
			}

			@Override
			public void onNeptuneSuccess(Boolean result) {
				tab.getView().hideBusyIndicator();
				if (result) {
					tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(myConstants.ratingTabName(), tab.getCommaSeparatedList(getRatingAndSystemList(itemIds))));
				} else {
					tab.setError(myConstants.deleteFailed());
					return;
				}
				getList();
			}
		});
	}

	@Override
	public void get(String... ids) {
		if (ids.length != 2) {
			//TODO: set error on UI
			return;
		}
		
		tab.getView().showBusyIndicator();
		
		service.getRating(ids[0], ids[1], new NeptuneAsyncCallback<UiRating>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				//TODO: set error on UI
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiRating result) {
				//TODO: show content on edit screen
				tab.getView().hideBusyIndicator();
			}
		});
	}


	@Override
	public void update(final UiRating item) {
		tab.getView().showBusyIndicator();
		
		service.updateRating(item, new NeptuneAsyncCallback<UiRating>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.setError(caught.getMessage());
				tab.refreshCreateView(item);
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiRating result) {
				tab.refreshCreateView(null);
				tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(myConstants.ratingTabName(), getRatingAndSystemForDisplay(item.getRating(), item.getRatingSystem())));
				tab.getView().hideBusyIndicator();
				getList();
				tab.showListPanel();
			}
			
		});
	}
	
	private String getRatingAndSystemForDisplay(String key1, String key2) {
		return "[" + key1 + ", " + key2 + "]";
	}

	private String getRatingAndSystemForDisplay(String item) {
		String[] arr = item.split(UiRatingRecord.RATING_ID_SEPARATOR);
		if (arr.length != 2)
			return item;
		return getRatingAndSystemForDisplay(arr[0], arr[1]);
	}
	
	private List<String> getRatingAndSystemList(List<String> itemIds) {
		List<String> retVal = new ArrayList<String>();
		for (String item : itemIds) {
			retVal.add(getRatingAndSystemForDisplay(item));
		}
		return retVal;
	}
}
