package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.i18n.client.HasDirection.Direction;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiRating;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

public class RatingConfigTab extends MetadataConfigTab<UiRating, String, UiRatingRecord> {

	private boolean createViewInitialized = false;
	private TextBox ratingTxt = null;
	private TextBox ratingSystemTxt = null;
	private TextArea descriptionTxt = null;
	
	public RatingConfigTab(MetadataConfigLazyView view) {
		super(view);
	}
	
	@Override
	protected void createController() {
		controller = new RatingConfigController(this);
	}

	@Override
	public void refreshCreateView(UiRating item) {
		if (ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE)) {
			if (!createViewInitialized) {
				FormContainer form = new FormContainer(HorizontalAlignmentConstant.endOf(Direction.DEFAULT));
				ratingTxt = new TextBox();
				ratingTxt.addStyleName(TEXT_BOX_SHORT_STYLE);
				form.addRow(new LabelWidget(constants.rColumnHeadingRating()), ratingTxt, true);
				ratingSystemTxt = new TextBox();
				ratingSystemTxt.addStyleName(TEXT_BOX_SHORT_STYLE);
				form.addRow(new LabelWidget(constants.rColumnHeadingRatingSystem()), ratingSystemTxt, true);
				descriptionTxt = new TextArea();
				descriptionTxt.addStyleName(TEXT_AREA_STYLE);
				form.addRow(new LabelWidget(constants.gColumnHeadingDescription()), descriptionTxt, false);
				createPanel.add(form);
				createViewInitialized = true;
			}
			
			if (item == null) {
				ratingTxt.setText("");
				ratingSystemTxt.setText("");
				descriptionTxt.setText("");
			} else {
				ratingTxt.setText(item.getRating() == null ? "" : item.getRating());
				ratingSystemTxt.setText(item.getRatingSystem() == null ? "" : item.getRatingSystem());
				descriptionTxt.setText(item.getDescription() == null ? "" : item.getDescription());
			}
		}
	}

	@Override
	protected Table<String, UiRatingRecord> createTable() {
		RatingDataProvider dataProvider = new RatingDataProvider(view, this);
		Table<String, UiRatingRecord> tbl = new Table<String, UiRatingRecord>(dataProvider);
		dataProvider.setTable(tbl);
		List<Column<?, UiRatingRecord>> columns = dataProvider.getColumns();
		SortFeature<String, UiRatingRecord> sortFeature = new SortFeatureImpl<String, UiRatingRecord>(columns.get(0), SortOrder.ASCENDING);
		sortFeature.getSortableColumns().addAll(columns);
		tbl.addSortFeature(sortFeature);
		tbl.initialize(null);
		return tbl;
	}

	@Override
	public void delete(List<UiRatingRecord> selectedIds) {
		if(Window.confirm(constants.confirmDelete())) {
			List<String> itemIds = new ArrayList<String>();
			for (UiRatingRecord id : selectedIds) {
				itemIds.add(id.getKey());
			}
			controller.delete(itemIds);
		}
	}

	private String validateInput() {
		String rating = ratingTxt.getText();
		String ratingSystem = ratingSystemTxt.getText();
		if (isBlank(rating)) {
			return constants.errBlankRating();
		}
		if (isBlank(ratingSystem)) {
			return constants.errBlankRatingSystem();
		}
		if (rating.trim().length() > 64) {
			return constants.errRatingTooLong();
		}
		if (ratingSystem.trim().length() > 64) {
			return constants.errRatingSystemTooLong();
		}
		String description = descriptionTxt.getText();
		if (!isBlank(description) && description.trim().length() > 255) {
			return constants.errDescriptionTooLong();
		}
		return "";
	}

	@Override
	public void save() {
		String err = validateInput();
		if (err.length() > 0) {
			setError(err);
			return;
		}
		clearErrors();
		if (controller != null) {
			UiRating rating = new UiRating();
			rating.setRating(ratingTxt.getText().trim());
			rating.setRatingSystem(ratingSystemTxt.getText().trim());
			rating.setDescription(descriptionTxt.getText().trim());
			controller.update(rating);
		}
	}

}
