package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiRating;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiRatingConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiRatingConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

/**
 * DataProvider for Rating table
 */
public class RatingDataProvider implements DataProvider<String, UiRatingRecord> {
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	private UiRatingConfigServiceAsync service = GWT.create(UiRatingConfigService.class);
	private Table<String, UiRatingRecord> table;
	private List<Column<?, UiRatingRecord>> columns = null;
	private MetadataConfigLazyView view = null;
	
	private String lastColumnName = "";
	private SortOrder lastSortOrder = SortOrder.ASCENDING;

	private RatingConfigTab tab;

	public RatingDataProvider(MetadataConfigLazyView view, RatingConfigTab tab) {
		this.tab = tab;
		this.view = view;
	}

	@Override
	public List<Column<?, UiRatingRecord>> getColumns() {
		if (columns != null)
			return columns;
		
		columns = new ArrayList<Column<?,UiRatingRecord>>();
		
		columns.add(new ColumnBase<UiRatingRecord, UiRatingRecord>("RATING", myConstants.rColumnHeadingRating()) {
			@Override
			public View<UiRatingRecord> getView(final UiRatingRecord record) {
				return new View<UiRatingRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getRatingDisplay());
						label.setTitle(record.getRating().getRating());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
					
				};
			}
		});
		
		columns.add(new ColumnBase<UiRatingRecord, UiRatingRecord>("RATINGSYSTEM", myConstants.rColumnHeadingRatingSystem()) {
			@Override
			public View<UiRatingRecord> getView(final UiRatingRecord record) {
				return new View<UiRatingRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getRatingSystemDisplay());
						label.setTitle(record.getRating().getRatingSystem());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
					
				};
			}
		});

		columns.add(new ColumnBase<UiRatingRecord, UiRatingRecord>("DESCRIPTION", myConstants.rColumnHeadingDescription()){
			@Override
			public View<UiRatingRecord> getView(final UiRatingRecord record) {
				return new View<UiRatingRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getDescriptionDisplay());
						label.setTitle(record.getRating().getDescription());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
				};
			}
		});

		return columns;
	}

	@Override
	public void getRecord(String key, AsyncCallback<UiRatingRecord> callback) {
		callback.onSuccess(null);
	}

	@Override
	public void getRecords(final AsyncCallback<List<UiRatingRecord>> callback) {
		String columnName = table.getSortFeature().getSortColumn().getName();
		SortOrder sortOrder = table.getSortFeature().getSortOrder();
		
		if (!columnName.equalsIgnoreCase(lastColumnName) || !sortOrder.equals(lastSortOrder)) {
			if (tab != null) {
				tab.clearErrors();
			}
		}
		lastColumnName = columnName;
		lastSortOrder = sortOrder;
		view.showBusyIndicator();
		
		service.getAllRatings(columnName, (sortOrder.equals(SortOrder.DESCENDING) ? true : false), new NeptuneAsyncCallback<List<UiRating>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				if (tab != null) {
					tab.setError(caught.getMessage());
				}
//				callback.onFailure(caught);
				callback.onFailure(null);
				view.hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(List<UiRating> result) {
				callback.onSuccess(convertRecords(result));
				view.hideBusyIndicator();
			}
		});
	}

	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	@Override
	public boolean isCheckboxEnabled() {
		return true;
	}

	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}
	
	private List<UiRatingRecord> convertRecords(List<UiRating> results) {
		List<UiRatingRecord> retVal = new ArrayList<UiRatingRecord>();
		for (UiRating item : results) {
			retVal.add(new UiRatingRecord(item));
		}
		return retVal;
	}
	
	public void setTable(Table<String, UiRatingRecord> table) {
		this.table = table;
	}
}
