package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.rating;

import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiRating;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Record wrapper for <UiRating>
 * The ...Display() methods are used to make sure the data displayed in table columns does not exceed a predefined length. 
 * Data exceeding limit is chopped off and shown as a continuation mark '...' at the end. A tool tip displays complete data.
 */
public class UiRatingRecord implements Record<String> {
	private final UiRating rating;
	public static final String RATING_ID_SEPARATOR = "::";
	
	public UiRatingRecord(UiRating rating) {
		this.rating = rating;
	}

	@Override
	public String getKey() {
		return rating.getRating() + RATING_ID_SEPARATOR + rating.getRatingSystem();
	}

	public UiRating getRating() {
		return rating;
	}

	public String getRatingDisplay() {
		String retVal = rating.getRating();
		if (retVal != null && retVal.length() > MetadataConfigConstants.ID_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.ID_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}
	
	public String getRatingSystemDisplay() {
		String retVal = rating.getRatingSystem();
		if (retVal != null && retVal.length() > MetadataConfigConstants.ID_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.ID_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}

	public String getDescriptionDisplay() {
		String retVal = rating.getDescription();
		if (retVal != null && retVal.length() > MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}
}
