package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.metadataconfig.IMetadataConfigController;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigMessageCache;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiStudio;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiStudioConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiStudioConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class StudioConfigController implements IMetadataConfigController<UiStudio> {
	private UiStudioConfigServiceAsync service = GWT.create(UiStudioConfigService.class);
	private MetadataConfigTab<UiStudio, String, UiStudioRecord> tab;
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	public StudioConfigController(MetadataConfigTab<UiStudio, String, UiStudioRecord> tab) {
		this.tab = tab;
	}

	@Override
	public void getList() {
		tab.getTable().refresh();
	}
	
	@Override
	public void delete(final List<String> itemIds) {
		tab.getView().showBusyIndicator();
		
		service.deleteStuido(itemIds, new NeptuneAsyncCallback<Boolean>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.getView().hideBusyIndicator();
				tab.setError(caught.getMessage());
			}

			@Override
			public void onNeptuneSuccess(Boolean result) {
				tab.getView().hideBusyIndicator();
				if (result) {
					tab.setWarning(MetadataConfigMessageCache.getMessages().metadataDeleteMessage(myConstants.studioTabName(), tab.getCommaSeparatedList(itemIds)));
				} else {
					tab.setError(myConstants.deleteFailed());
					return;
				}
				getList();
			}
		});
	}

	@Override
	public void get(String... ids) {
		if (ids.length != 1) {
			//TODO: set error on UI
			return;
		}
		
		tab.getView().showBusyIndicator();
		
		service.getStudio(ids[0], new NeptuneAsyncCallback<UiStudio>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				//TODO: set error on UI
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiStudio result) {
				//TODO: show content on edit screen
				tab.getView().hideBusyIndicator();
			}
		});
	}


	@Override
	public void update(final UiStudio item) {
		tab.getView().showBusyIndicator();
		
		service.updateStudio(item, new NeptuneAsyncCallback<UiStudio>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				tab.setError(caught.getMessage());
				tab.refreshCreateView(item);
				tab.getView().hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(UiStudio result) {
				tab.refreshCreateView(null);
				tab.setWarning(MetadataConfigMessageCache.getMessages().metadataCreateMessage(myConstants.studioTabName(), item.getDisplayName()));
				tab.getView().hideBusyIndicator();
				getList();
				tab.showListPanel();
			}
			
		});
	}
}
