package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.i18n.client.HasDirection.Direction;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigTab;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiStudio;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

public class StudioConfigTab extends MetadataConfigTab<UiStudio, String, UiStudioRecord> {

	private boolean createViewInitialized = false;
	private TextBox displayNameTxt = null;
	private TextBox organizationNameTxt = null;
	private TextBox organizationCodeTxt = null;
	private TextArea descriptionTxt = null;
	
	public StudioConfigTab(MetadataConfigLazyView view) {
		super(view);
	}
	
	@Override
	protected void createController() {
		controller = new StudioConfigController(this);
	}
	
	@Override
	public void refreshCreateView(UiStudio item) {
		if (ClientAuthorizationManager.isAuthorized(Permissions.METADATA_CONFIG_CREATE)) {
			if (!createViewInitialized) {
				FormContainer form = new FormContainer(HorizontalAlignmentConstant.endOf(Direction.DEFAULT));
				displayNameTxt = new TextBox();
				displayNameTxt.addStyleName(TEXT_BOX_SHORT_STYLE);
				form.addRow(new LabelWidget(constants.sColumnHeadingDisplayName()), displayNameTxt, true);
				organizationNameTxt = new TextBox();
				organizationNameTxt.addStyleName(TEXT_BOX_LONG_STYLE);
				form.addRow(new LabelWidget(constants.sColumnHeadingOrganizatinName()), organizationNameTxt, true);
				organizationCodeTxt = new TextBox();
				organizationCodeTxt.addStyleName(TEXT_BOX_SHORT_STYLE);
				form.addRow(new LabelWidget(constants.sColumnHeadingOrganizationCode()), organizationCodeTxt, false);
				descriptionTxt = new TextArea();
				descriptionTxt.addStyleName(TEXT_AREA_STYLE);
				form.addRow(new LabelWidget(constants.gColumnHeadingDescription()), descriptionTxt, false);
				createPanel.add(form);
				createViewInitialized = true;
			}
			
			if (item == null) {
				displayNameTxt.setText("");
				organizationNameTxt.setText("");
				organizationCodeTxt.setText("");
				descriptionTxt.setText("");
			} else {
				displayNameTxt.setText(item.getDisplayName() == null ? "" : item.getDisplayName());
				organizationNameTxt.setText(item.getOrganizationName() == null ? "" : item.getOrganizationName());
				organizationCodeTxt.setText(item.getOrganizationCode() == null ? "" : item.getOrganizationCode());
				descriptionTxt.setText(item.getDescription() == null ? "" : item.getDescription());
			}
		}
	}

	@Override
	protected Table<String, UiStudioRecord> createTable() {
		StudioDataProvider dataProvider = new StudioDataProvider(view, this);
		Table<String, UiStudioRecord> tbl = new Table<String, UiStudioRecord>(dataProvider);
		dataProvider.setTable(tbl);
		List<Column<?, UiStudioRecord>> columns = dataProvider.getColumns();
		SortFeature<String, UiStudioRecord> sortFeature = new SortFeatureImpl<String, UiStudioRecord>(columns.get(0), SortOrder.ASCENDING);
		sortFeature.getSortableColumns().addAll(columns);
		tbl.addSortFeature(sortFeature);
		tbl.initialize(null);
		return tbl;
	}

	@Override
	public void delete(List<UiStudioRecord> selectedIds) {
		if(Window.confirm(constants.confirmDelete())) {
			List<String> itemIds = new ArrayList<String>();
			for (UiStudioRecord id : selectedIds) {
				itemIds.add(id.getKey());
			}
			controller.delete(itemIds);
		}
	}
	
	private String validateInput() {
		String displayName = displayNameTxt.getText();
		String orgName = organizationNameTxt.getText();
		if (isBlank(displayName)) {
			return constants.errBlankDisplayName();
		}
		if (isBlank(orgName)) {
			return constants.errBlankOrganizationName();
		}
		if (displayName.trim().length() > 64) {
			return constants.errDisplayNameTooLong();
		}
		if (orgName.trim().length() > 255) {
			return constants.errOrganizationNameTooLong();
		}
		String orgCode = organizationCodeTxt.getText();
		if (!isBlank(orgCode) && orgCode.trim().length() > 64) {
			return constants.errOrganizationCodeTooLong();
		}
		String description = descriptionTxt.getText();
		if (!isBlank(description) && description.trim().length() > 255) {
			return constants.errDescriptionTooLong();
		}
		return "";
	}

	@Override
	public void save() {
		String err = validateInput();
		if (err.length() > 0) {
			setError(err);
			return;
		}
		clearErrors();
		if (controller != null) {
			UiStudio studio = new UiStudio();
			studio.setDisplayName(displayNameTxt.getText().trim());
			studio.setOrganizationName(organizationNameTxt.getText().trim());
			studio.setOrganizationCode(organizationCodeTxt.getText().trim());
			studio.setDescription(descriptionTxt.getText().trim());
			controller.update(studio);
		}
	}

}
