package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigLazyView;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiStudio;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiStudioConfigService;
import com.tandbergtv.cms.portal.content.client.metadataconfig.service.UiStudioConfigServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

/**
 * DataProvider for Studio table
 */
public class StudioDataProvider implements DataProvider<String, UiStudioRecord> {
	private MetadataConfigConstants myConstants = (MetadataConfigConstants) GWT.create(MetadataConfigConstants.class);
	
	private UiStudioConfigServiceAsync service = GWT.create(UiStudioConfigService.class);
	private Table<String, UiStudioRecord> table;
	private List<Column<?, UiStudioRecord>> columns = null;
	private MetadataConfigLazyView view = null;
	
	private String lastColumnName = "";
	private SortOrder lastSortOrder = SortOrder.ASCENDING;

	private StudioConfigTab tab;

	public StudioDataProvider(MetadataConfigLazyView view, StudioConfigTab tab) {
		this.tab = tab;
		this.view = view;
	}

	@Override
	public List<Column<?, UiStudioRecord>> getColumns() {
		if (columns != null)
			return columns;
		
		columns = new ArrayList<Column<?,UiStudioRecord>>();
		
		columns.add(new ColumnBase<UiStudioRecord, UiStudioRecord>("DISPLAYNAME", myConstants.sColumnHeadingDisplayName()) {
			@Override
			public View<UiStudioRecord> getView(final UiStudioRecord record) {
				return new View<UiStudioRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getDisplayNameDisplay());
						label.setTitle(record.getStudio().getDisplayName());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
					
				};
			}
		});
		
		columns.add(new ColumnBase<UiStudioRecord, UiStudioRecord>("ORGANIZATIONNAME", myConstants.sColumnHeadingOrganizatinName()){
			@Override
			public View<UiStudioRecord> getView(final UiStudioRecord record) {
				return new View<UiStudioRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getOrganizationNameDisplay());
						label.setTitle(record.getStudio().getOrganizationName());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
				};
			}
		});
		
		columns.add(new ColumnBase<UiStudioRecord, UiStudioRecord>("ORGANIZATIONCODE", myConstants.sColumnHeadingOrganizationCode()){
			@Override
			public View<UiStudioRecord> getView(final UiStudioRecord record) {
				return new View<UiStudioRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getOrganizationCodeDisplay());
						label.setTitle(record.getStudio().getOrganizationCode());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
				};
			}
		});

		columns.add(new ColumnBase<UiStudioRecord, UiStudioRecord>("DESCRIPTION", myConstants.sColumnHeadingDescription()){
			@Override
			public View<UiStudioRecord> getView(final UiStudioRecord record) {
				return new View<UiStudioRecord>() {
					@Override
					public String getStyleName() {
						return null;
					}

					@Override
					public Widget getWidget() {
						LabelWidget label = new LabelWidget(record.getDescriptionDisplay());
						label.setTitle(record.getStudio().getDescription());
						return label;
					}

					@Override
					public void release() {
						//Nothing to do here
					}
				};
			}
		});

		return columns;
	}

	@Override
	public void getRecord(String key, AsyncCallback<UiStudioRecord> callback) {
		callback.onSuccess(null);
	}

	@Override
	public void getRecords(final AsyncCallback<List<UiStudioRecord>> callback) {
		String columnName = table.getSortFeature().getSortColumn().getName();
		SortOrder sortOrder = table.getSortFeature().getSortOrder();
		
		if (!columnName.equalsIgnoreCase(lastColumnName) || !sortOrder.equals(lastSortOrder)) {
			if (tab != null) {
				tab.clearErrors();
			}
		}
		lastColumnName = columnName;
		lastSortOrder = sortOrder;
		view.showBusyIndicator();
		
		service.getAllStudios(columnName, (sortOrder.equals(SortOrder.DESCENDING) ? true : false), new NeptuneAsyncCallback<List<UiStudio>>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				if (tab != null) {
					tab.setError(caught.getMessage());
				}
//				callback.onFailure(caught);
				callback.onFailure(null);
				view.hideBusyIndicator();
			}

			@Override
			public void onNeptuneSuccess(List<UiStudio> result) {
				callback.onSuccess(convertRecords(result));
				view.hideBusyIndicator();
			}
		});
	}

	@Override
	public void initialize(AsyncCallback<Void> callback) {
		callback.onSuccess(null);
	}

	@Override
	public boolean isCheckboxEnabled() {
		return true;
	}

	@Override
	public boolean isRecordCountEnabled() {
		return true;
	}
	
	private List<UiStudioRecord> convertRecords(List<UiStudio> results) {
		List<UiStudioRecord> retVal = new ArrayList<UiStudioRecord>();
		for (UiStudio item : results) {
			retVal.add(new UiStudioRecord(item));
		}
		return retVal;
	}
	
	public void setTable(Table<String, UiStudioRecord> table) {
		this.table = table;
	}
}
