package com.tandbergtv.cms.portal.content.client.metadataconfig.tab.studio;

import com.tandbergtv.cms.portal.content.client.metadataconfig.MetadataConfigConstants;
import com.tandbergtv.cms.portal.content.client.metadataconfig.model.UiStudio;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Record wrapper for <UiStudio>
 * The ...Display() methods are used to make sure the data displayed in table columns does not exceed a predefined length. 
 * Data exceeding limit is chopped off and shown as a continuation mark '...' at the end. A tool tip displays complete data.
 */
public class UiStudioRecord implements Record<String> {
	private final UiStudio studio;
	
	public UiStudioRecord(UiStudio studio) {
		this.studio = studio;
	}

	@Override
	public String getKey() {
		return studio.getDisplayName();
	}

	public UiStudio getStudio() {
		return studio;
	}
	
	public String getDisplayNameDisplay() {
		String retVal = studio.getDisplayName();
		if (retVal != null && retVal.length() > MetadataConfigConstants.ID_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.ID_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}
	
	public String getOrganizationNameDisplay() {
		String retVal = studio.getOrganizationName();
		if (retVal != null && retVal.length() > MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}	

	public String getOrganizationCodeDisplay() {
		String retVal = studio.getOrganizationCode();
		if (retVal != null && retVal.length() > MetadataConfigConstants.ID_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.ID_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}

	public String getDescriptionDisplay() {
		String retVal = studio.getDescription();
		if (retVal != null && retVal.length() > MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH) {
			retVal = retVal.substring(0, MetadataConfigConstants.DESCRIPTION_COLUMN_MAX_WIDTH - MetadataConfigConstants.STRING_CONTINUATION.length()) 
					+ MetadataConfigConstants.STRING_CONTINUATION;
		}
		return retVal;
	}	
}
