package com.tandbergtv.cms.portal.content.client.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Asset representation for the UI layer
 * 
 * @author spuranik
 * 
 */
public class UiAsset implements IsSerializable {

	private long id;
	private String type;
	private List<UiField> fields;

	public UiAsset() {
		this.fields = new ArrayList<UiField>();
	}
	
	public UiAsset(long id ) {
		setId(id);
	}

	public UiAsset(long id, String type, List<UiField> fields) {
		setId(id);
		setType(type);
		setFields(fields);
	}

	/**
	 * @return the id
	 */
	public long getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(long id) {
		this.id = id;
	}

	/**
	 * @return the filteredFields
	 */
	public List<UiField> getFields() {
		return fields;
	}

	/**
	 * @param filteredFields
	 *            the filteredFields to set
	 */
	public void setFields(List<UiField> fields) {
		this.fields = fields;
	}

	public void addField(UiField field) {
		this.fields.add(field);
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getType() {
		return type;
	}
}
