package com.tandbergtv.cms.portal.content.client.model;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Ui object which represents title
 * 
 * @author spuranik
 * 
 */
public class UiTitle implements IsSerializable {

	private long titleId;
	private Long partnerId;
	private List<UiField> fields;
	private UiAsset asset;
	

	public UiTitle() { 
		fields = new ArrayList<UiField>();
	}
	
	public UiTitle(long id) {
		this();
		this.titleId = id;
	}
	
	public UiTitle(long id, Long partnerId) {
		this( id ); 
		this.partnerId = partnerId;
	}
	
	public UiTitle(long id, List<UiField> fields) {
		this( id );
		this.fields = fields;
		if ( this.fields ==  null ) {
			this.fields = new ArrayList<UiField>();
		}
	}

	/**
	 * @return the titleId
	 */
	public long getTitleId() {
		return titleId;
	}

	/**
	 * @param titleId
	 *            the titleId to set
	 */
	public void setTitleId(long titleId) {
		this.titleId = titleId;
	}

	/**
	 * @param partnerId
	 *            the partnerId to set
	 */
	public void setPartnerId( Long partnerId ) {
		this.partnerId = partnerId;
	}

	/**
	 * @return the partnerId
	 */
	public Long getPartnerId() {
		return partnerId;
	}

	public void setFields(List<UiField> fields) {
	    this.fields = fields;
	}

	public List<UiField> getFields() {
	    return fields;
	}

	/**
	 * @return the asset
	 */
	public UiAsset getAsset() {
		return asset;
	}

	/**
	 * @param asset
	 *            the asset to set
	 */
	public void setAsset(UiAsset asset) {
		this.asset = asset;
	}
}
