package com.tandbergtv.cms.portal.content.client.portlet.modified;


import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.model.portlet.modified.ModifiedTitleRecord;
import com.tandbergtv.cms.portal.content.client.model.portlet.modified.ModifiedTitlesData;
import com.tandbergtv.cms.portal.content.client.model.portlet.modified.TitleMetadata;
import com.tandbergtv.cms.portal.content.client.portlet.PortletConstants;
import com.tandbergtv.cms.portal.content.client.portlet.activity.ImageHyperlink;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;

public class LastModifiedPortlet extends Portlet {

	private NeptuneSecurity security;

	private FlexTableContainer table;

	private Timer refreshTimer;

	private PortletConstants constants;

	private SpecificationServiceAsync tableService;

	private IModifiedTitlesListPortletServiceAsync portletService;

	String spec;

	private static final String TABLE_NAME = "title.portlet.Metadata";

	private String SPECIFICATION_KEY = "ContentComponent.Specification";

	private static final String CONTENT_VIEW_PERMISSION = "AssetManagement_View";

	private int refreshPeriod;

	private UiTable uiTable;

	private Map<String, String> info;

	public LastModifiedPortlet(NeptuneSecurity security,
			Map<String, String> info, int refreshTimeInSecs) {
	        super("LAST_MODIFIED");
		this.security = security;
		this.info = info;
		this.spec = getSpecificationName();
		this.refreshPeriod = getRefreshPeriodInMills(refreshTimeInSecs);

		tableService = GWT.create(SpecificationService.class);

		constants = GWT.create(PortletConstants.class);

		portletService = GWT.create(IModifiedTitlesListPortletService.class);

		setTitle(constants.modifiedTitle());
		setDisplayName(constants.modifiedTitle());

		table = new FlexTableContainer();
		table.setCellSpacing(0);
		table.setStyleName("portletTable");
		add(table);

		this.refreshTimer = new Timer() {
			@Override
			public void run() {
				reload();
			}
		};
		EventHandler handler = new EventHandler();
		addDocumentAttachHandler(handler);
		addDocumentDetachHandler(handler);
	}

	private void reload() {
		initializeTable();
		portletService.getData(new NeptuneAsyncCallback<ModifiedTitlesData>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
			}

			@Override
			public void onNeptuneSuccess(ModifiedTitlesData data) {
				clearTableData();
				if(data.getCount() == 0)
					return;
				prepareTableHeader(data);
				populateTableData(data);
				update();
			}

		});
	}

	private void prepareTableHeader(ModifiedTitlesData data) {
		
		
		List<UiColumn> columns = uiTable.getColumns();
		if (columns == null)
			return;
		
		// add status column header first	
		table.setWidget(0, 0, new LabelWidget(constants.titleStatus()));
		table.getCellFormatter().setStyleName(0, 0,
				"portlet-tableHeader");
		
		int colIndex = 1;
		for (int i = 0; i < columns.size(); i++) {
			UiColumn col = columns.get(i);

			String colHeader = col.getDisplayName();
			table.setWidget(0, colIndex, new LabelWidget(colHeader));
			table.getCellFormatter().setStyleName(0, colIndex, "portlet-tableHeader");
			colIndex++;
		}

		// add last updated timestamp
		table.setWidget(0, colIndex, new LabelWidget(constants
				.lastUpdatedTime()));
		table.getCellFormatter().setStyleName(0, colIndex,
				"portlet-tableHeader");

	}

	private void buildStatusWidget(int dataRow, int colIndex, ModifiedTitleRecord record){
		Image statusImage = new Image();
		new TitleClientBundle().updateTitleStatusIcon(statusImage, record.getStatus());
		// add status column header in the the last
		if(security.isUserInRole(CONTENT_VIEW_PERMISSION))
			table.setWidget(dataRow, colIndex, new ImageHyperlink(statusImage,
					"Content.Search.Id=" + record.getTitleId()));
		else
			table.setWidget(dataRow, colIndex, new LabelWidget(constants.titleStatus()));
		
		table.getCellFormatter().setStyleName(dataRow, colIndex,
					"portlet-table-icons");
		
	}
	private void populateTableData(ModifiedTitlesData data) {
		List<ModifiedTitleRecord> records = data.getRecords();
	
		int dataRow = 1;
		for (int i = 0; i < records.size(); i++) {
			
			int colIndex = 0;
			ModifiedTitleRecord record = records.get(i);
			// add title status
			buildStatusWidget(dataRow, colIndex, record);
			colIndex = colIndex + 1;
			// populate title metadata
			List<TitleMetadata> metadata = record.getMetadata();
			populateTitleMetadata(dataRow, colIndex, metadata, record.getTitleId());

			int metdataCount = (metadata != null) ? metadata.size() : 0;
			colIndex = colIndex + metdataCount;
			// add last modified timestamp
			table.setWidget(dataRow, colIndex, new LabelWidget(record.getLastModifiedTime()));
			table.getCellFormatter().setStyleName(dataRow, colIndex,
					"portlet-table-text");
			dataRow++;
		}
	}

	private void clearTableData() {
		table.removeAllRows();
	}

	/**
	 * prepares table based on default UI specification
	 */
	private void initializeTable() {
		// get table columns
		tableService.getTable(TABLE_NAME, new NeptuneAsyncCallback<UiTable>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
			}

			@Override
			public void onNeptuneSuccess(UiTable uiTable) {

				setTable(uiTable);
			}
		});
	}

	private void setTable(UiTable table) {
		uiTable = table;
	}

	/**
	 * currently assumes that always first metadata column is hyperlink.
	 * Ideally, this should come from specification table configuration
	 * 
	 * @param row
	 * @param metadata
	 * @param titleId
	 */
	private void populateTitleMetadata(int row, int column, List<TitleMetadata> metadata,
			long titleId) {
		if (metadata == null)
			return;

		for (int i = 0; i < metadata.size(); i++) {
			int colIndex = column + i;
			// TODO: HACK should come from configuration
			if (colIndex == 1 && security.isUserInRole(CONTENT_VIEW_PERMISSION))
				table.setWidget(row, colIndex, buildHyperLinkWidget(metadata.get(i)
						.getValue(), "Content.Search.Id=" + titleId));
			else
				table.setWidget(row, colIndex, new LabelWidget(metadata.get(i)
						.getValue()));
			table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-text");

		}
	}

	/**
	 * gets refresh period from configuration
	 * 
	 * @param info
	 * @return
	 */
	private int getRefreshPeriodInMills(int refresh) {
		return refresh * 1000; // in millis
	}


	private String getSpecificationName() {
		return info.get(SPECIFICATION_KEY);
	}

	/*
	 * Event Handling
	 */
	private final class EventHandler implements DocumentAttachHandler,
			DocumentDetachHandler {
		@Override
		public void onAttach(DocumentAttachEvent event) {
			refreshTimer.scheduleRepeating(refreshPeriod);
			reload();
		}

		@Override
		public void onDetach(DocumentDetachEvent event) {
			refreshTimer.cancel();
		}
	}

	private Widget buildHyperLinkWidget(String label, String url) {
		return new HyperlinkWidget(label, url);
	}
}
