package com.tandbergtv.cms.portal.content.client.rpc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Response returned after attempting to queue workorders for the selected titelist(s).  
 * 
 * @author spuranik
 *
 */
public class WorkOrderCreateResponse implements IsSerializable {

	// list of titlelist id
	private List<Long> queuedWorkOrders;
	// map of titlelist/title id -> exception message
	private Map<Long, String> failedIds;

	public WorkOrderCreateResponse() {
		this.queuedWorkOrders = new ArrayList<Long>();
		this.failedIds = new HashMap<Long, String>();
	}

	/**
	 * @return the queuedWorkOrders
	 */
	public List<Long> getQueuedWorkOrders() {
		return queuedWorkOrders;
	}

	/**
	 * @param queuedWorkOrders the queuedWorkOrders to set
	 */
	public void setQueuedWorkOrders(List<Long> queuedWorkOrders) {
		this.queuedWorkOrders = queuedWorkOrders;
	}

	/**
	 * @return the failedTitleLists
	 */
	public Map<Long, String> getFailedIds() {
		return failedIds;
	}

	/**
	 * @param failedIds the failedTitleLists to set
	 */
	public void setFailedIds(Map<Long, String> failedIds) {
		this.failedIds = failedIds;
	}	
}
