/*
 * Created on Apr 29, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.rpc.lookupkey;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiAssetType;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiLookupKey;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Service for managing lookup keys
 * 
 * @author Daniel Paranhos
 */
@RemoteServiceRelativePath("service/content/lookupKeyService")
public interface ILookupKeyService extends RemoteService {

    /**
     * Gets the lookup key corresponding to this lookup key id.
     * 
     * @param id
     *            the lookup key id
     * @return the lookup key
     */
    UiLookupKey get( long id ) throws NeptuneException;

    /**
     * Creates/updates a lookup key in the system with the given info
     * 
     * @param lookupKey
     * @return the lookup key just saved
     */
    UiLookupKey save( UiLookupKey lookupKey ) throws NeptuneException;

    /**
     * Gets all the existing lookup keys in the system.
     * 
     * @param sortByProperty
     *            the sort by column name
     * @param isAscending
     *            indicates if the order is ascending (true) or descending
     *            (false)
     * @return the list of lookup keys
     */
    List<UiLookupKey> getLookupKeys( String sortByProperty, boolean isAscending ) throws NeptuneException;

    /**
     * Gets all the existing lookup keys in the system for the given asset type
     * 
     * @param assetType
     *            the asset type
     * @return the list of lookup keys
     */
    List<UiLookupKey> getLookupKeysByAssetType( String assetType ) throws NeptuneException;

    /**
     * Gets all the existing asset types in the system
     * 
     * @return the list of ui asset types
     */
    List<UiAssetType> getAllAssetTypes() throws NeptuneException;

}