/*
 * Created on Apr 29, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.rpc.lookupkey;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiAssetType;
import com.tandbergtv.cms.portal.content.client.lookupkey.model.UiLookupKey;

/**
 * Service for managing lookup keys
 * 
 * @author Daniel Paranhos
 */
public interface ILookupKeyServiceAsync {

    /**
     * Gets the lookup key corresponding to this lookup key id.
     * 
     * @param id
     *            the lookup key id
     * @param callback
     *            the callback that will be called to receive the return value
     */
    void get( long id, AsyncCallback<UiLookupKey> callback );

    /**
     * Creates/updates a lookup key in the system with the given info
     * 
     * @param lookupKey
     * @param callback
     *            the callback that will be called to receive the return value
     */
    void save( UiLookupKey lookupKey, AsyncCallback<UiLookupKey> callback );

    /**
     * Gets all the existing lookup keys in the system.
     * 
     * @param sortByProperty
     *            the sort by column name
     * @param isAscending
     *            indicates if the order is ascending (true) or descending
     *            (false)
     * @param callback
     *            the callback that will be called to receive the return value
     */
    void getLookupKeys( String sortByProperty, boolean isAscending, AsyncCallback<List<UiLookupKey>> callback );

    /**
     * Gets all the existing lookup keys in the system for the given asset type
     * 
     * @param assetType
     *            the asset type
     * @param callback
     *            the callback that will be called to receive the return value
     */
    void getLookupKeysByAssetType( String assetType, AsyncCallback<List<UiLookupKey>> callback );

    /**
     * Gets all the existing asset types in the system
     * 
     * @param callback
     *            the callback that will be called to receive the return value
     */
    void getAllAssetTypes( AsyncCallback<List<UiAssetType>> callback );

}