package com.tandbergtv.cms.portal.content.client.rpc.title;

import java.util.HashSet;
import java.util.Set;

import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

public class AssociatedToTitleListUIException extends NeptuneException {
	private static final long serialVersionUID = 1L;
	
	private Set<Long> schedulerIds = new HashSet<Long>();
	private Set<Long> plannerIds = new HashSet<Long>();
	private Set<Long> assetListIds = new HashSet<Long>();
	
	public AssociatedToTitleListUIException() { }
	
	public AssociatedToTitleListUIException(Set<Long> schedulerIds, Set<Long> plannerIds, Set<Long> assetListIds) {
		if (schedulerIds != null) {
			this.setSchedulerIds(schedulerIds);
		}
		if (plannerIds != null) {
			this.setPlannerIds(plannerIds);
		}
		if (assetListIds != null) {
			this.setAssetListIds(assetListIds);
		}
	}
	
	@Override
	public String getMessage() {
		return "Associated to: " +
				"[Schedulers: " + schedulerIds + "], " +
				"[Planners: " + plannerIds + "], " +
				"[AssetLists: " + assetListIds + "]";
	}

	public void setSchedulerIds(Set<Long> schedulerIds) {
		this.schedulerIds = schedulerIds;
	}

	public Set<Long> getSchedulerIds() {
		return schedulerIds;
	}

	public void setPlannerIds(Set<Long> plannerIds) {
		this.plannerIds = plannerIds;
	}

	public Set<Long> getPlannerIds() {
		return plannerIds;
	}

	public void setAssetListIds(Set<Long> assetListIds) {
		this.assetListIds = assetListIds;
	}

	public Set<Long> getAssetListIds() {
		return assetListIds;
	}
	
}
