/*
 * Created on Feb 25, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.content.client.rpc.title;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Service to perform the 'Delete' action for the Title Service
 * 
 * @author Vijay Silva
 */
@RemoteServiceRelativePath("service/content/titleService/ITitleDeleteService")
public interface ITitleDeleteService extends RemoteService {

	/**
	 * Deletes the titles with matching title IDs. This is an atomic operation. 
	 * 
	 * @param assetId The title ID
	 * @param dissociateFromTitleLists flag that indicates whether to dissociate from any Title List
	 */
	public void delete(List<Long> titleIds, boolean dissociateFromTitleLists) throws NeptuneException;
}
