package com.tandbergtv.cms.portal.content.client.rpc.title;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.model.UiRuleSet;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Interface which exposes api for communication between ui and backend for title's run normalization rule 
 * action.
 * 
 * @author esakhat (sanjay.khattar@ericsson.com)
 * 
 */
@RemoteServiceRelativePath("service/content/TitleNormalizationRuleService")
public interface ITitleNormalizationRuleService extends RemoteService {

	/**
	 * Gets a list of enabled normalization rules.
	 * 
	 * @return 
	 */
	List<UiRuleSet> getNormalizationRules() throws NeptuneException;
	
	/**
	 * Sends a message to apply the given rule to the given titleIds. 
	 * 
	 * @param titleIds
	 * @param ruleSetId
	 */
	void sendRuleExecutionMessage(List<Long> titleIds,
			Integer ruleSetId) throws NeptuneException;
}
