package com.tandbergtv.cms.portal.content.client.rpc.title;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Interface which exposes api for communication between ui and backend for title's run template 
 * action.
 * 
 * @author spuranik
 * 
 */
@RemoteServiceRelativePath("service/content/titleTemplateProvider")
public interface ITitleTemplateService extends RemoteService {

	/**
	 * Gets list of template names which accept title ids as a required parameter.
	 * 
	 * @return 
	 */
	List<String> getTemplates() throws NeptuneException;
	
	/**
	 * Gets list of template names with annotation.
	 * 
	 * @return 
	 */
	List<String> getTemplatesWithAnnotation(String annotation) throws NeptuneException;
	
	/**
	 * Creates a WPCL indicating to create a process for the given template name and title id. 
	 * 
	 * @param titleId
	 * @param templateName
	 */
	WorkOrderCreateResponse sendWorkOrderCreateMessage(List<Long> titleIds,
			String templateName) throws NeptuneException;
}
