package com.tandbergtv.cms.portal.content.client.rpc.title;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;

public interface ITitleTemplateServiceAsync  {

	/**
	 * Gets list of template names which accept title ids as a required parameter.
	 * 
	 * @return 
	 */
	void getTemplates(AsyncCallback<List<String>> callback);
	
	/**
	 * Gets list of template names with annotation.
	 * 
	 * @return 
	 */
	void getTemplatesWithAnnotation(String annotation, AsyncCallback<List<String>> callback);
	
	/**
	 * Creates a WPCL and sends it to workflow. 
	 * 
	 * @param titleId
	 * @param templateName
	 * @param callback
	 */
	void sendWorkOrderCreateMessage(List<Long> titleIds, String templateName,
			AsyncCallback<WorkOrderCreateResponse> callback);
}
