package com.tandbergtv.cms.portal.content.client.rpc.title;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * A simple value object to hold all the details saved as search preferences.
 * 
 * @author spuranik
 * 
 */
public class SearchColumnPreference implements IsSerializable {

	// indicates selected columns
	List<SearchPreferenceDisplayColumn> selectedColumns;
	// indicates sorting info
	SearchPreferenceDisplayColumn sortColumn;
	// ordinal of the sort order enum is persisted in the db
	int sortOrder = -1;
	
	public SearchColumnPreference() {
		
	}

	public SearchColumnPreference(List<SearchPreferenceDisplayColumn> selectedColumns,
			SearchPreferenceDisplayColumn sortColumn, int sortOrder) {
		this.selectedColumns = selectedColumns;
		this.sortColumn = sortColumn;
		this.sortOrder = sortOrder;
	}
	
	public SearchPreferenceDisplayColumn getSortColumn() {
		return sortColumn;
	}

	public void setSortColumn(SearchPreferenceDisplayColumn sortColumn) {
		this.sortColumn = sortColumn;
	}

	public int getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(int sortOrder) {
		this.sortOrder = sortOrder;
	}

	public List<SearchPreferenceDisplayColumn> getSelectedColumns() {
		return selectedColumns;
	}

	public void setSelectedColumns(List<SearchPreferenceDisplayColumn> selectedColumn) {
		this.selectedColumns = selectedColumn;
	} 
}
