package com.tandbergtv.cms.portal.content.client.rpc.title;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UiAsset;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/content/titleSearchService")
public interface TitleSearchService extends RemoteService {

	/**
	 * Gets the list of assets that match the criteria built from the list of
	 * searchfields.
	 * 
	 * @param spec
	 * 
	 * @param titleFilterNode
	 *            List of fields, start/end index, sort order from which the
	 *            search criteria will be built.
	 * @return list of assets as the UI expects it along with the total count of
	 *         matching assets found.
	 */
	UISearchResult getTitles(UITitleFilter titleFilter, List<UiColumn> columns) throws NeptuneException;

	String performExortToExcel(UITitleFilter titleFilter, List<UiColumn> columns) throws NeptuneException;
	
	List<UiAsset> getAssetInfo(Long titleId, List<UiColumn> col) throws NeptuneException; 
}
