package com.tandbergtv.cms.portal.content.client.rpc.title;

import java.util.List;
import java.util.Set;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleSearch;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleSearchBase;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/title/uiTitleCriteriaService")
public interface UiTitleCriteriaService extends RemoteService {

	int saveTitleSearch(UITitleSearch titleSearch) throws NeptuneException;

	UITitleSearch getTitleSearch(int titleSearchId) throws NeptuneException;

	List<UITitleSearchBase> getTitleSearches(int offset, int count,
			String userName, UiCriteriaMode criteriaMode) throws NeptuneException;

	void deleteTitleSearch(int titleSearchId) throws NeptuneException;
	
	void deleteTitleSearches(Set<Integer> titleSearchIds) throws NeptuneException;

	void saveSearchColumnsAsPreference(SearchColumnPreference preference, UiCriteriaMode criteriaMode);
	
	SearchColumnPreference getSearchColumnPreferences(UiCriteriaMode criteriaMode);
}
