/**
 * 
 */
package com.tandbergtv.cms.portal.content.client.rpc.title;

import java.util.List;
import java.util.Set;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleSearch;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleSearchBase;

/**
 * @author dweiner
 * @generated generated asynchronous callback interface to be used on the client side
 *
 */
public interface UiTitleCriteriaServiceAsync {

	/**
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void saveTitleSearch(UITitleSearch titleSearch,
			AsyncCallback<Integer> callback);

	/**
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getTitleSearch(int titleSearchId, AsyncCallback<UITitleSearch> callback);

	/**
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void getTitleSearches(int offset, int count, String userName, UiCriteriaMode criteriaMode,
			AsyncCallback<List<UITitleSearchBase>> callback);

	/**
	 * @param  callback the callback that will be called to receive the return value
	 * @generated generated method with asynchronous callback parameter to be used on the client side
	 */
	void deleteTitleSearch(int titleSearchId, AsyncCallback<Void> callback);

	void deleteTitleSearches(Set<Integer> titleSearchIds, AsyncCallback<Void> callback);

	/**
	 * saves the given list of columns in the user preferences.
	 * 
	 */
	void saveSearchColumnsAsPreference(SearchColumnPreference searchPreferences,
			UiCriteriaMode criteriaMode, AsyncCallback<Void> callback);
	
	/**
	 * Gets the search column preferences for the current user.
	 * 
	 * @param callback
	 */
	void getSearchColumnPreferences(UiCriteriaMode criteriaMode,
			AsyncCallback<SearchColumnPreference> callback);
}
