package com.tandbergtv.cms.portal.content.client.services.title;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.title.ContentClassCheck;
import com.tandbergtv.cms.portal.content.client.rpc.title.ContentClassCheckAsync;
import com.tandbergtv.cms.portal.content.client.rpc.title.ContentClassCheckResponse;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

/**
 * Service that bulk edits given assets.
 * 
 * @author spuranik
 * 
 */
public class BulkEditService implements ITitleService {
	private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
	private static final ContentClassCheckAsync checker = GWT.create(ContentClassCheck.class);
	
	private List<Long> titleIds = null;
	private long contentClassId = 0;
	
	private TitleListPanel view;
	private BusyIndicator busyIndicator = new BusyIndicator();
	
	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
	}

	
	public void execute(final List<Long> titleIds, String serviceParameter,
			IActionInput input, final AsyncCallback<IOperationResult> callback) {

		busyIndicator.center();
		checker.titlesAreOfTheSameContentClass(titleIds, new NeptuneAsyncCallback<ContentClassCheckResponse>() 
		{
			@Override
			public void onNeptuneFailure(Throwable caught) {
				busyIndicator.hide();
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(ContentClassCheckResponse result) {
				busyIndicator.hide();
				if (titleIds.size() > 0 && result.isSuccess()) {
					contentClassId = result.getContentClassId();
					callback.onSuccess(new BulkEditResult());
				} 
				else if(!result.isSuccess()) {
					callback.onFailure(new RuntimeException(displayConstants.bulkEditServiceContentClassError()));
				} 
				else {
					callback.onFailure(new RuntimeException(displayConstants.bulkdEditServiceTileSelectionError()));
				}
			}
		});
		
		this.titleIds = titleIds;
	}

	public String getDescription() {
		return displayConstants.bulkEditServiceDescription();
	}

	public String getName() {
		return displayConstants.bulkEditServiceName();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService
	 * #gotoResultPage
	 * (com.tandbergtv.cms.portal.ui.title.client.model.uiservice.
	 * ITitleOperationResult,
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView)
	 */
	public void gotoResultPage(IOperationResult result, IView sourceView) {
		view = (TitleListPanel)sourceView;
		view.showTitleDetails(titleIds, contentClassId);
	}

	public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
		callback.onSuccess(null);
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	@Override
	public boolean getConfirmation() {
		return false;
	}

	@Override
	public boolean isSelected(ViewInput inputData) {
		return false;
	}
	
	@Override
	public boolean needTitlesTobeSelected() {
		return true;
	}

}
