package com.tandbergtv.cms.portal.content.client.services.title;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.title.AssociatedToTitleListUIException;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleDeleteService;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleDeleteServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * This service is responsible to delete titles given the list of title ids.
 * 
 * @author spuranik
 * 
 */
public class DeleteService implements ITitleService {

	private ContentConstants displayConstants = (ContentConstants) GWT
			.create(ContentConstants.class);
	
	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER, SITE, SERIES");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE, SINGLE");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService
	 * #execute(java.util.List, com.google.gwt.user.client.rpc.AsyncCallback)
	 */
	public void execute(final List<Long> titleIds, String serviceParameter,
			IActionInput input, final AsyncCallback<IOperationResult> callback) {
		final ITitleDeleteServiceAsync service = GWT
				.create(ITitleDeleteService.class);

		service.delete(titleIds, false, new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				if(caught instanceof AssociatedToTitleListUIException) {
					confirmWithUser( (AssociatedToTitleListUIException) caught,
						
						new Runnable() {
    						@Override
    						public void run() {
    							service.delete(titleIds, true, new NeptuneAsyncCallback<Void>() {
    								@Override
    								public void onNeptuneFailure(Throwable caught) {
    									handleServiceFailure(titleIds, callback, caught);
    								}
    		
    								@Override
    								public void onNeptuneSuccess(Void result) {
    									handleServiceSuccess(titleIds, callback);
    								}
    							});
    						}
    					},
						
						new Runnable() {
							@Override
							public void run() {
								callback.onSuccess(new DeleteResult(displayConstants.deleteServiceUserAbort()));
							}
    					}
    				);
				} else {
					handleServiceFailure(titleIds, callback, caught);
				}
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				handleServiceSuccess(titleIds, callback);
			}			
		});
	}
	
	private void handleServiceSuccess(List<Long> titleIds,
			AsyncCallback<IOperationResult> callback) {
		callback.onSuccess(new DeleteResult(displayConstants.deleteServiceSuccess() + " "
				+ getTitleIdsList(titleIds)));
	}

	private void handleServiceFailure(List<Long> titleIds,
			AsyncCallback<IOperationResult> callback, Throwable caught) {
		String errorMsg = displayConstants.deleteServiceFailure()
				+ getTitleIdsList(titleIds) + " " + caught.getLocalizedMessage();
		callback.onFailure(new NeptuneException(errorMsg));
	}

	private void confirmWithUser(AssociatedToTitleListUIException exception, final Runnable yes, final Runnable no) {
		final PopupContainer confirmation = new PopupContainer(false, true);
		VerticalContainer popContainer = new VerticalContainer();
		
		popContainer.add(new LabelWidget( getConfirmMessage(exception) ));
		HorizontalContainer buttonContainer = new HorizontalContainer();
		
		// yes button
		ButtonWidget yesButton = new ButtonWidget(displayConstants.confirmationYes());
		yesButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		yesButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				confirmation.hide();
				yes.run();
			}
		});
		buttonContainer.add(yesButton);
		
		// no button
		ButtonWidget noButton = new ButtonWidget(displayConstants.confirmationNo());
		noButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		noButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				confirmation.hide();
				no.run();
			} });
		buttonContainer.add(noButton);
		
		popContainer.add(buttonContainer);
		popContainer.setCellHorizontalAlignment(buttonContainer, VerticalContainer.ALIGN_CENTER);
		confirmation.add(popContainer);
		confirmation.center();
		confirmation.show();
	}

	private String getConfirmMessage(AssociatedToTitleListUIException exception) {
		StringBuilder messageSB = new StringBuilder( displayConstants.deleteServiceConfirmAssociationBegin() );
		messageSB.append( " " );
		List<String> associatedItems = new ArrayList<String>();
		if ( !exception.getSchedulerIds().isEmpty() ) {
			associatedItems.add( displayConstants.deleteServiceConfirmAssociationSchedules() );
		}
		if ( !exception.getPlannerIds().isEmpty() ) {
			associatedItems.add( displayConstants.deleteServiceConfirmAssociationPlanners() );
		}
		if ( !exception.getAssetListIds().isEmpty() ) {
			associatedItems.add( displayConstants.deleteServiceConfirmAssociationTitleLists() );
		}
		for ( int x=0; x<associatedItems.size(); x++ ) {
			messageSB.append( associatedItems.get(x) );
			if ( x == (associatedItems.size() - 2) ) {
				messageSB.append( " " );
				messageSB.append( displayConstants.deleteServiceConfirmAssociationAnd() );
				messageSB.append( " " );
			} else if ( x < (associatedItems.size() - 2) ){
				messageSB.append( ", " );
			}
		}
		messageSB.append( displayConstants.deleteServiceConfirmAssociationEnd() );
		
		return messageSB.toString();
	}

	/**
	 * prepares a comma separated list of ids
	 * 
	 * @param response
	 * @return
	 */
	private String getTitleIdsList(List<Long> titleIds) {
		StringBuilder deletedIds = new StringBuilder();
		for (long id : titleIds) {
			if (deletedIds.length() > 0) {
				deletedIds.append(", ");
			}
			deletedIds.append(id);
		}
		return deletedIds.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService
	 * #getDescription()
	 */
	public String getDescription() {
		return displayConstants.deleteServiceDescription();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService
	 * #getName()
	 */
	public String getName() {
		return displayConstants.deleteServiceName();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService
	 * #gotoResultPage
	 * (com.tandbergtv.cms.portal.ui.title.client.model.uiservice.
	 * ITitleOperationResult,
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView)
	 */
	public void gotoResultPage(IOperationResult result, IView sourceView) {
		sourceView.refresh(result.getMessage());
	}

	public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
		callback.onSuccess(null);
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	@Override
	public boolean getConfirmation() {
		return true;
	}

	@Override
	public boolean isSelected(ViewInput inputData) {
		// never select this service
		return false;
	}
	
	@Override
	public boolean needTitlesTobeSelected() {
		return true;
	}

}
