package com.tandbergtv.cms.portal.content.client.services.title;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesService;
import com.tandbergtv.cms.portal.content.client.title.service.ITitleSitesServiceAsync;
import com.tandbergtv.cms.portal.content.client.title.service.TargetSitesResponse;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * Service that lets the user distribute to the assigned site.
 * 
 * @author Bryan Kim
 * 
 */
public class Distribute implements ITitleService {

	private String NEWLINE_CHAR = "\n";
	private ContentConstants displayConstants = (ContentConstants) GWT.create(ContentConstants.class);
	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "SITE");
		_serviceActionParameters.put("UPDATE_TYPE", "SINGLE");
	}

	@Override
	public void execute(List<Long> titleIds, final String serviceParameter,
			IActionInput input, final AsyncCallback<IOperationResult> callback) {

		ITitleSitesServiceAsync service = GWT.create(ITitleSitesService.class);
		service.distributeImmediately(titleIds.get(0), new NeptuneAsyncCallback<TargetSitesResponse>() {
				public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}
	
			public void onNeptuneSuccess(TargetSitesResponse response) {
				callback.onSuccess(prepareResult(response));
			}
		});
	}

	private IOperationResult prepareResult(TargetSitesResponse response) {
		StringBuilder sb = new StringBuilder();
		
		// sucessfully queued work orders
		if(response.getTargetTitleIds().size() > 0) {
			sb.append(displayConstants.runDistributeSitesServiceSuccess());
			StringBuilder ids = new StringBuilder();
			for (long id : response.getTargetTitleIds()) {
				if (ids.length() > 0) {
					ids.append(", ");
				}
				ids.append(id);
			}
			sb.append(ids.toString());
		}
		
		// failed to queue work orders for these ids
		if(response.getFailedIds().size() > 0) {
			sb.append(NEWLINE_CHAR);
			sb.append(displayConstants.runDistributeSitesServiceFailure());
			StringBuilder failedIds = new StringBuilder();
			Iterator<Entry<Long, String>> iter = response.getFailedIds().entrySet().iterator();
			while (iter.hasNext()) {
				Entry<Long, String> entry = iter.next();
				if (failedIds.length() > 0) {
					failedIds.append(NEWLINE_CHAR);
				}
				failedIds.append(entry.getKey() + "[" + entry.getValue() + "]");
			}
			sb.append(failedIds.toString());
		}
		return new DistributeSitesResult(sb.toString());
	}
	
	@Override
	public String getDescription() {
		return displayConstants.runDistributeSitesServiceDescription();  
	}

	@Override
	public String getName() {
		return displayConstants.runDistributeSitesServiceName(); 
	}

	@Override
	public void getServiceParameters(final NeptuneAsyncCallback<List<String>> callback) {
		callback.onSuccess(null);
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	@Override
	public void gotoResultPage(IOperationResult result, IView sourceView) {
		sourceView.refresh(result.getMessage());		
	}

	/**
	 * Class that holds the message which will be displayed on the ui that invoked this service.
	 *
	 */
	private class DistributeSitesResult implements IOperationResult {
		String message;

		public DistributeSitesResult(String message) {
			this.message = message;
		}

		public String getMessage() {
			return message;
		}
	}

	@Override
	public boolean getConfirmation() {
		return true;
	}
	
	@Override
	public boolean isSelected(ViewInput inputData) {
		return false;
	}
	
	@Override
	public boolean needTitlesTobeSelected() {
		return true;
	}

}
