package com.tandbergtv.cms.portal.content.client.services.title;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiRuleSet;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleNormalizationRuleService;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleNormalizationRuleServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

/**
 * Service that runs Normalization Rule for the given assets.
 * 
 * @author esakhat (sanjay.khattar@ericsson.com)
 * 
 */
public class RunNormalizationRuleService implements ITitleService {
	
	public static final String SERVICE_PARAM_SEPARATOR = "ParamSeparator";
	
	private static final ContentConstants displayConstants = (ContentConstants) GWT.create(ContentConstants.class);
	private static final ITitleNormalizationRuleServiceAsync normalizationRuleService = GWT.create(ITitleNormalizationRuleService.class);
	
	private BusyIndicator busyIndicator = new BusyIndicator();
	
	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE, SINGLE");
	}

	
	public void execute(final List<Long> titleIds, final String serviceParameter,
			IActionInput input, final AsyncCallback<IOperationResult> callback) {

		// Do nothing here because the user has not yet selected the normalization rule
		if (serviceParameter == null || serviceParameter.isEmpty()) {
			callback.onFailure(new RuntimeException(
					displayConstants.runNormalizationRuleServiceRuleSelectionError()));
			return;
		} 

		busyIndicator.center();
		normalizationRuleService.sendRuleExecutionMessage(titleIds, Integer.valueOf(serviceParameter), new NeptuneAsyncCallback<Void>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
				busyIndicator.hide();
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				callback.onSuccess(new RunNormalizationRuleResult(displayConstants.runNormalizationRuleServiceSuccess()));
				busyIndicator.hide();
			}
			
		});
	}

	public String getDescription() {
		return displayConstants.runNormalizationRuleServiceDescription();
	}

	public String getName() {
		return displayConstants.runNormalizationRuleServiceName();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService
	 * #gotoResultPage
	 * (com.tandbergtv.cms.portal.ui.title.client.model.uiservice.
	 * ITitleOperationResult,
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView)
	 */
	public void gotoResultPage(IOperationResult result, IView sourceView) {
		sourceView.refresh(result.getMessage());
	}

	public void getServiceParameters(final NeptuneAsyncCallback<List<String>> callback) {
		normalizationRuleService.getNormalizationRules(new NeptuneAsyncCallback<List<UiRuleSet>>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(List<UiRuleSet> result) {
				List<String> serviceParameters = new ArrayList<String>(result.size());
				for (UiRuleSet uiRuleSet : result) {
					serviceParameters.add(uiRuleSet.getName()
							+ SERVICE_PARAM_SEPARATOR
							+ String.valueOf(uiRuleSet.getId()));
				}
				callback.onSuccess(serviceParameters);
			}
			
		});
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	@Override
	public boolean getConfirmation() {
		return false;
	}

	@Override
	public boolean isSelected(ViewInput inputData) {
		return false;
	}
	
	@Override
	public boolean needTitlesTobeSelected() {
		return true;
	}
	
	/**
	 * Class that holds the message which will be displayed on the ui that invoked this service.
	 *
	 */
	private class RunNormalizationRuleResult implements IOperationResult {
		String message;

		public RunNormalizationRuleResult(String message) {
			this.message = message;
		}

		public String getMessage() {
			return message;
		}
	}

}
