package com.tandbergtv.cms.portal.content.client.services.title;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleTemplateService;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleTemplateServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;

import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * Service that lets the user select a site template to run given the list of title ids.
 * 
 * @author Bryan Kim
 * 
 */
public class RunSiteTemplate extends RunTemplate implements ITitleService {

	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "SITE");
		_serviceActionParameters.put("UPDATE_TYPE", "SINGLE");
	}


	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService#getServiceParameters(com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback)
	 */
	@Override
	public void getServiceParameters(final NeptuneAsyncCallback<List<String>> callback) {
		ITitleTemplateServiceAsync service = GWT.create(ITitleTemplateService.class);
		service.getTemplatesWithAnnotation("LocalContentProcessing", new NeptuneAsyncCallback<List<String>>() {
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			public void onNeptuneSuccess(List<String> result) {
				callback.onSuccess(result);
			}
		});
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

}
