package com.tandbergtv.cms.portal.content.client.services.title;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleTemplateService;
import com.tandbergtv.cms.portal.content.client.rpc.title.ITitleTemplateServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * Service that lets the user select a template to run given the list of title ids.
 * 
 * @author spuranik
 * 
 */
public class RunTemplate implements ITitleService {
	
	private String NEWLINE_CHAR = "\n";
	private ContentConstants displayConstants = (ContentConstants) GWT.create(ContentConstants.class);
	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE, SINGLE");
	}

	public void execute(List<Long> titleIds, final String serviceParameter,
			IActionInput input, final AsyncCallback<IOperationResult> callback) {
		// Do nothing here because the user has not yet selected the template
		if (serviceParameter == null || serviceParameter.isEmpty()) {
			callback.onFailure(new RuntimeException(
					displayConstants.runTemplateServiceTemplateSelectionError()));
			return;
		} 
	
		ITitleTemplateServiceAsync service = GWT.create(ITitleTemplateService.class);
		service.sendWorkOrderCreateMessage(titleIds, serviceParameter,
			new NeptuneAsyncCallback<WorkOrderCreateResponse>() {
				public void onNeptuneFailure(Throwable caught) {
					callback.onFailure(caught);
				}

				public void onNeptuneSuccess(
						WorkOrderCreateResponse response) {
					callback.onSuccess(prepareResult(response));
				}
			});
	}	

	/**
	 * Prepares a message indicating titleids for which work orders were
	 * scheduled and those which were not.
	 * 
	 * @param response
	 * @return
	 */
	private IOperationResult prepareResult(WorkOrderCreateResponse response) {
		StringBuilder sb = new StringBuilder();
		
		// sucessfully queued work orders
		if(response.getQueuedWorkOrders().size() > 0) {
			sb.append(displayConstants.runTemplateServiceSuccess());
			StringBuilder ids = new StringBuilder();
			for (long id : response.getQueuedWorkOrders()) {
				if (ids.length() > 0) {
					ids.append(", ");
				}
				ids.append(id);
			}
			sb.append(ids.toString());
		}
		
		// failed to queue work orders for these ids
		if(response.getFailedIds().size() > 0) {
			sb.append(NEWLINE_CHAR);
			sb.append(displayConstants.runTemplateServiceFailure());
			StringBuilder failedIds = new StringBuilder();
			Iterator<Entry<Long, String>> iter = response.getFailedIds().entrySet().iterator();
			while (iter.hasNext()) {
				Entry<Long, String> entry = iter.next();
				if (failedIds.length() > 0) {
					failedIds.append(NEWLINE_CHAR);
				}
				failedIds.append(entry.getKey() + "[" + entry.getValue() + "]");
			}
			sb.append(failedIds.toString());
		}
		return new RunTemplateResult(sb.toString());
	}

	
	public String getDescription() {
		return displayConstants.runTemplateServiceDescription();
	}

	public String getName() {
		return displayConstants.runTemplateServiceName();
	}

	public void gotoResultPage(IOperationResult result, IView sourceView) {
		sourceView.refresh(result.getMessage());
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService#getServiceParameters(com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback)
	 */
	public void getServiceParameters(final NeptuneAsyncCallback<List<String>> callback) {
		ITitleTemplateServiceAsync service = GWT.create(ITitleTemplateService.class);
		service.getTemplates(new NeptuneAsyncCallback<List<String>>() {
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			public void onNeptuneSuccess(List<String> result) {
				callback.onSuccess(result);
			}
		});
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	/**
	 * Class that holds the message which will be displayed on the ui that invoked this service.
	 *
	 */
	private class RunTemplateResult implements IOperationResult {
		String message;

		public RunTemplateResult(String message) {
			this.message = message;
		}

		public String getMessage() {
			return message;
		}
	}

	@Override
	public boolean getConfirmation() {
		return false;
	}

	@Override
	public boolean isSelected(ViewInput inputData) {
		// This service is never selected either as default because there is no
		// external page connecting to this feature.
		return false;
	}
	
	@Override
	public boolean needTitlesTobeSelected() {
		return true;
	}

}
