package com.tandbergtv.cms.portal.content.client.services.title;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.client.rpc.title.IPitchScheduleService;
import com.tandbergtv.cms.portal.content.client.rpc.title.IPitchScheduleServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class TerrestrialPitchBottom implements ITitleService{
	private ContentConstants displayConstants = (ContentConstants) GWT.create(ContentConstants.class);
	private String NEWLINE_CHAR = "\n";
	private String templateName ="";
	private String queueName = "Terrestrial Queue";
	private String queuePos = "BottomOfQueue";
	
	private static final Map<String, String> _serviceActionParameters;
	
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE, SINGLE");
	}
	
	private void executePitchWork(List<Long> ids, String trackingSiteName, IActionInput input, final AsyncCallback<IOperationResult> callback) {

	
		IPitchScheduleServiceAsync service = GWT.create(IPitchScheduleService.class);
		service.sendWorkOrderCreateMessage(ids, trackingSiteName, queueName, queuePos, templateName, 
		
			new NeptuneAsyncCallback<WorkOrderCreateResponse>() {
				public void onNeptuneFailure(Throwable caught) {
					callback.onFailure(caught);
				}

				public void onNeptuneSuccess(
						WorkOrderCreateResponse response) {
					callback.onSuccess(prepareResult(response));
				}
			});
		
	}

	@Override
	public void gotoResultPage(IOperationResult result, IView sourceView) {
		sourceView.refresh(result.getMessage());
	}
	private IOperationResult prepareResult(WorkOrderCreateResponse response) {
		StringBuilder sb = new StringBuilder();
		
		// sucessfully queued work orders
		if(response.getQueuedWorkOrders().size() > 0) {
			sb.append(displayConstants.runTemplateServiceSuccess());
			StringBuilder ids = new StringBuilder();
			for (long id : response.getQueuedWorkOrders()) {
				if (ids.length() > 0) {
					ids.append(", ");
				}
				ids.append(id);
			}
			sb.append(ids.toString());
		}
		
		// failed to queue work orders for these ids
		if(response.getFailedIds().size() > 0) {
			sb.append(NEWLINE_CHAR);
			sb.append(displayConstants.runTemplateServiceFailure());
			StringBuilder failedIds = new StringBuilder();
			Iterator<Entry<Long, String>> iter = response.getFailedIds().entrySet().iterator();
			while (iter.hasNext()) {
				Entry<Long, String> entry = iter.next();
				if (failedIds.length() > 0) {
					failedIds.append(NEWLINE_CHAR);
				}
				failedIds.append(entry.getKey() + "[" + entry.getValue() + "]");
			}
			sb.append(failedIds.toString());
		}
		return new ExecutionResult(sb.toString());
	}
	private class ExecutionResult implements IOperationResult {
		String message;

		public ExecutionResult(String message) {
			this.message = message;
		}

		public String getMessage() {
			return message;
		}
	}

	@Override
	public void getServiceParameters(final NeptuneAsyncCallback<List<String>> callback) {
		IPitchScheduleServiceAsync service = GWT.create(IPitchScheduleService.class);
		service.getTrackingSites(new NeptuneAsyncCallback<List<String>>() {
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			public void onNeptuneSuccess(List<String> result) {
				callback.onSuccess(result);
			}
		});    
		
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return displayConstants.terrestrialPitchBottomServiceName();
	}

	@Override
	public String getDescription() {
		// TODO Auto-generated method stub
		return displayConstants.pitchServiceDescription();
	}

	@Override
	public boolean getConfirmation() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isSelected(ViewInput inputData) {
		// TODO Auto-generated method stub
		return false;
	}
	
	@Override
	public boolean needTitlesTobeSelected() {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public void execute(List<Long> ids, String trackingSiteName, IActionInput input, AsyncCallback<IOperationResult> callback) {
		if (trackingSiteName == null || trackingSiteName.isEmpty()) {
			callback.onFailure(new RuntimeException(
					displayConstants.pitchServiceSiteSelectionError()));
			return;
		} 
		
		executePitchWork(ids, trackingSiteName, input, callback) ;
	}

}
