package com.tandbergtv.cms.portal.content.client.services.title;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchService;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class TitleSearchResultsExportService implements ITitleService {
	
	private static final ContentConstants displayConstants = (ContentConstants) GWT
			.create(ContentConstants.class);
	
	private static final Map<String, String> _serviceActionParameters;
	static {
		_serviceActionParameters = new HashMap<String, String>();
		_serviceActionParameters.put("TITLE_TYPE", "MASTER, SITE, SERIES");
		_serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
	}

	@Override
	public void execute(List<Long> ids, String serviceParameter,
			IActionInput input, final AsyncCallback<IOperationResult> callback) {
		TitleSearchServiceAsync searchService = GWT.create(TitleSearchService.class);
		ActionInput actionInput = (ActionInput) input;
		searchService.performExortToExcel(actionInput.getTitleFilter(),
				actionInput.getDp().getExportColumns(),
				new NeptuneAsyncCallback<String>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(String result) {
				Window.Location.replace("ExportSearchToExcel?GUID="+result);
			}			
		});
	}

	@Override
	public boolean getConfirmation() {
		return false;
	}

	@Override
	public String getDescription() {
		return displayConstants.titleSearchResultsExportServiceDescription();
	}

	@Override
	public String getName() {
		return displayConstants.titleSearchResultsExportName();
	}

	@Override
	public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
		callback.onSuccess(null);
	}
	
	@Override
	public Map<String, String> getServiceActionParameters() {
		return _serviceActionParameters;
	}

	@Override
	public void gotoResultPage(IOperationResult result, IView sourceView) {		
	}

	@Override
	public boolean isSelected(ViewInput inputData) {
		return false;
	}

	@Override
	public boolean needTitlesTobeSelected() {
		return false;
	}
}
