/*
 * Created on May 13, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.cms.portal.content.client.services.titleprogress;

import com.tandbergtv.cms.portal.content.client.ContentComponent;
import com.tandbergtv.cms.portal.content.client.Permissions;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleProgressService;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;

/**
 * Title Progress Service for the Content Component UI users
 * 
 * @author Vijay Silva
 */
public class TitleProgressService implements ITitleProgressService {

	private static final String INGEST_WEBSERVICE = "Metadata Ingest Service";
	private static final String ADI_SERVER = "ADI Server";

	/**
	 * Constructor
	 */
	public TitleProgressService() {
	}

	@Override
	public Hyperlink getLink(String componentName, String entityName, String sourceId,
	        String titleRevision) {
		if (ContentComponent.COMPONENT_NAME.equals(componentName)) {
			String name = sourceId;
			String targetHistoryToken = null;
			if (!ADI_SERVER.equals(entityName)) {
				/* The source name */
				if (INGEST_WEBSERVICE.equals(entityName)) {
					name += " (" + entityName + ")";
				}

				/* The history token string */
				if (ClientAuthorizationManager.isAuthorized(Permissions.USER_VIEW)) {
					targetHistoryToken = "Admin.User.Edit?userName=" + sourceId;
				}
			}

			return new Hyperlink(name, targetHistoryToken);
		}

		return null;
	}
}
