package com.tandbergtv.cms.portal.content.client.tab;

import java.util.List;
import java.util.MissingResourceException;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * Panel which contains a header and a message label used to show errors messages. 
 * 
 * @author spuranik
 * 
 */
public class ErrorPanel extends SimpleContainer {

	// widgets
	private VerticalContainer mainContainer;
	private LabelWidget headerLabel;
	private LabelWidget messageLabel;

	// styles
	private String SECTION_HEADING_STYLE = "content-TitleValidationView-sectionHeading"; //"titleValidationView-sectionHeading";
	private String ERROR_HEADING_STYLE = "content-TitleValidationView-sectionHeading-error"; //"titleValidationView-sectionHeading-error";
	private String ERROR_PANEL_STYLE = "content-TitleValidationView"; //"titleValidationView";
	private int PANEL_SPACING = 5;

	private ContentMessages messages = (ContentMessages) GWT.create(ContentMessages.class);
	private ContentConstants constants = (ContentConstants) GWT.create(ContentConstants.class);
	
	public ErrorPanel() {
		super();
		initWidgets();
	}

	private void initWidgets() {
		headerLabel = new LabelWidget();
		headerLabel.addStyleName(SECTION_HEADING_STYLE);
		headerLabel.addStyleName(ERROR_HEADING_STYLE);
		
		messageLabel = new LabelWidget();
		messageLabel.setWordWrap(true);
		
		mainContainer = new VerticalContainer();
		mainContainer.add(headerLabel);
		mainContainer.add(messageLabel);
		mainContainer.addStyleName(ERROR_PANEL_STYLE);
		mainContainer.setSpacing(PANEL_SPACING);
		// or else border doesn't show up
		mainContainer.setWidth("99%");
		
		add(mainContainer);
	}

	/**
	 * Given the list of ui error codes for title lists, prepares a message that is
	 * shown in the appropriate panel widgets.
	 * 
	 * @param errorCodes
	 */
	public void showErrorCodeMessages(List<String> errorCodes) {
		StringBuilder sb = new StringBuilder();
		for (String code : errorCodes) {
			if (sb.length() > 0) {
				sb.append("\n");
			}
			try{
				sb.append(constants.getString(code));
			}
			catch(MissingResourceException ex){
				sb.append(code);//hack code is indeed the error message
			}
		}
		headerLabel.setText(messages.titleListSaveFailure(errorCodes.size()));
		messageLabel.setText(sb.toString());
	}
	
	/**
	 * Displays a single error message.
	 * 
	 * @param message
	 */
	public void showErrorMessage(String message) {
		headerLabel.setText(messages.titleListSaveFailure(1));
		messageLabel.setText(message);
	}
	
	/**
	 * Clears the text in all contained widgets.
	 * 
	 */
	public void reset() {
		this.messageLabel.setText("");
		this.headerLabel.setText("");
	}
}
