package com.tandbergtv.cms.portal.content.client.tab;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * Widget used to display success messages for titlelists and title search results page.
 * 
 * @author spuranik
 *
 */
public class SucessPanel extends SimpleContainer {

	private VerticalContainer mainContainer;
	private VerticalContainer messageContainer;
	private String SUCCESS_MESSAGE_STYLE1 = "content-TitleView-feedbackPopup" ; //"titleViewFeedbackPopup";
	private String SUCCESS_MESSAGE_STYLE2 = "content-TitleView-feedbackLabel"; //"titleViewFeedbackLabel";

	public SucessPanel() {
		super();
		mainContainer = new VerticalContainer();
		messageContainer = new VerticalContainer();
		mainContainer.add(messageContainer);
		add(mainContainer);
	}

	private LabelWidget createMessageLabel(String message) {
		LabelWidget messageLabel = new LabelWidget();
		
		messageLabel.setText(message);
		messageLabel.addStyleName(SUCCESS_MESSAGE_STYLE1);
		messageLabel.addStyleName(SUCCESS_MESSAGE_STYLE2);
		messageLabel.setWordWrap(true);
		
		return messageLabel;
	}
	
	/**
	 * Sets the message text with the given value.
	 * 
	 * @param message
	 */
	public void showSuccessMessage(String message) {
		messageContainer.clear();
		if ( ( message != null) && ( !message.trim().equals( "" ) ) ) {
			messageContainer.add( createMessageLabel( message ) );
		}
	}
	
	/**
	 * Adds the message text with the given value.
	 * 
	 * @param message
	 */
	public void addSuccessMessage(String message) {
		messageContainer.add( createMessageLabel( message ) );		
	}
	
	/**
	 * Clears the text in all contained widgets.
	 * 
	 */
	public void reset() {
		messageContainer.clear();
	}
}
