package com.tandbergtv.cms.portal.content.client.tab.create;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.view.ContentCreateController;
import com.tandbergtv.cms.portal.content.client.title.view.ContentCreateView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyView;

/**
 * Lazily initializes ContentCreateView 
 * @author eyevkar
 */
public class ContentCreateLazyView extends LazyView {
	// Main view
	private ContentCreateView view;
	// Controller
	private ContentCreateController controller;
	
	/**
	 * Constructor
	 */
	public ContentCreateLazyView() {
	}

	@Override
	protected void setWidgetAnchor(String anchor) {
		controller.showSelectorView(anchor);
	}

	@Override
	protected Widget createWidget() {
		view = new ContentCreateView();
		// Circular reference!
		controller = new ContentCreateController(view);
		view.setController(controller);
		return view;
	}

	@Override
	public String getAnchor() {
		return null;
	}
}
