package com.tandbergtv.cms.portal.content.client.tab.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.AssetRecord;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleAssetDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ExpandingProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SelectionChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SelectionChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table.RefreshListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.CheckBox;

public class TitleListExpandingProvider implements ExpandingProvider<Long, TitleRecord, Long, AssetRecord> {

	private Table<Long, TitleRecord> table;

	private UiTable uiTable;

	private Map<TitleRecord, Table<Long, AssetRecord>> tableCacheMap;

	public TitleListExpandingProvider(UiTable uiTable) {
		this.uiTable = uiTable;
		tableCacheMap = new HashMap<TitleRecord, Table<Long, AssetRecord>>();
	}

	@Override
	public List<AssetRecord> getSelectedRecords() {
		List<AssetRecord> selectedRecords = new ArrayList<AssetRecord>();
		for (Table<Long, AssetRecord> table : tableCacheMap.values()) {
			selectedRecords.addAll(table.getSelectedRecords());
		}
		return selectedRecords;
	}

	@Override
	public List<AssetRecord> getSelectedRecords(TitleRecord parentRecord) {
		List<AssetRecord> selectedRecords = new ArrayList<AssetRecord>();
		Table<Long, AssetRecord> table = tableCacheMap.get(parentRecord);
		if (table != null) {
			selectedRecords.addAll(table.getSelectedRecords());
		}
		return selectedRecords;
	}

	@Override
	public Widget getWidget(TitleRecord parentRecord) {
		Table<Long, AssetRecord> table = tableCacheMap.get(parentRecord);
		if ( table == null ) {
    		TitleAssetDataProvider dataProvider = new TitleAssetDataProvider(parentRecord, uiTable);
    		table = new Table<Long, AssetRecord>(dataProvider);
    		/* Ensure that the table is initialized before making calls to the table */
    		table.initialize( new TableCallback( table ) );
    		table.addSelectionChangeHandler(new SelectionChangeHandler<Long, AssetRecord>() {
    
    			@Override
    			public void onSelectionChange(SelectionChangeEvent<Long, AssetRecord> event) {
    				handleSelectionChangeEvent(event);
    
    			}
    		});
    		tableCacheMap.put(parentRecord, table);
		}
		return table;
	}

	private void handleSelectionChangeEvent(SelectionChangeEvent<Long, AssetRecord> event) {
		Set<Entry<TitleRecord, Table<Long, AssetRecord>>> cacheEntrySet = tableCacheMap.entrySet();

		for (Entry<TitleRecord, Table<Long, AssetRecord>> entry : cacheEntrySet) {
			Table<Long, AssetRecord> cachedTable = entry.getValue();
			if (cachedTable.equals(event.getSource())) {
				if (cachedTable.getSelectedRecords().size() > 0) {
					table.setSelectedForRecord(entry.getKey(), true);
				} else {
					table.setSelectedForRecord(entry.getKey(), false);
					table.setHeaderRowSelected(false);
				}
				break;
			}
		}
	}

	@Override
	public void parentSelectionChanged(TitleRecord parentRecord, boolean selected) {
		Table<Long, AssetRecord> table = tableCacheMap.get(parentRecord);
		if ( table == null ) {
			getWidget(parentRecord);
			table = tableCacheMap.get(parentRecord);
			table.addRefreshListener( new TableRefreshListener( table, selected ) );
		} else {
    		if (table != null) {
    			changeChildrenSelections(selected, table);
    		}
    	}
	}

	private void changeChildrenSelections(boolean selected, Table<Long, AssetRecord> table) {
		List<CheckBox<AssetRecord>> dataRowsCheckBoxes = table.getDataRowsCheckBoxes();
		for (CheckBox<AssetRecord> checkBox : dataRowsCheckBoxes) {
			if ( selected ) {
				// Just select the first record (the root asset)
				checkBox.setValue(selected);
				break;
			} else {
				checkBox.setValue(selected);
			}
		}
		if ( !selected ) {
			table.setHeaderRowSelected(false);
		}
	}

	public void setTable(Table<Long, TitleRecord> table) {
		this.table = table;
	}

	public Table<Long, TitleRecord> getTable() {
		return table;
	}
	
	class TableCallback extends NeptuneAsyncCallback<Void> {
		
		private Table<Long, AssetRecord> table;
		
		public TableCallback(Table<Long, AssetRecord> table) {
			this.table = table;
		}

		@Override
		public void onNeptuneFailure(Throwable caught) {
			Window.alert(caught.getLocalizedMessage());
		}

		@Override
		public void onNeptuneSuccess(Void result) {
			table.refresh();
		}
	};
	
	class TableRefreshListener implements RefreshListener {
		
		private boolean selected;
		
		private Table<Long, AssetRecord> table;

		public TableRefreshListener(Table<Long, AssetRecord> table, boolean selected) {
			this.table = table;
			this.selected = selected;
		}

		@Override
		public void updated() {
			changeChildrenSelections(selected, table);			
		}
		
	}
	
}



