package com.tandbergtv.cms.portal.content.client.tab.list;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.model.UiServiceItem;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.content.client.services.title.RunNormalizationRuleService;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionInput;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionListDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.AssetRecord;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.SearchResultColumnBuilder;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.UiAssetTableDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.TitleListButtonClickListener;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchResultsPanel;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.series.SeriesTitleView;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UISortOrder;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.CookieStoreBasedPageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.ExpandingFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasViewCancelHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCancelHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCommitEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewCommitHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * Panel which is shows the list of assets.
 * 
 * @author spuranik
 */
public class TitleListPanel extends Composite implements IView, HasViewCancelHandlers, IMessageEmitter {
	
	private static final String TITLE_ASSET_LIST_TABLE = "titleListAssetColumns";
	private static final String STYLE_NAME = "content-TitleListPanel";
	private static final int SPACING = 2;

	// widgets
	private SimpleContainer rootContainer;
	private VerticalContainer container;
	
	// input
	private NeptuneSecurity security;
	private String specificationName;
	private UITitleFilter titleFilter;
	private ServiceLoader serviceLoader;
	private TitleListViewInput input;
	private Long requestKey;
	private String action;
	private String listOfAssetIds;
	private final BusyIndicator busyIndicator = new BusyIndicator();

	// map for services
	private ServiceMap serviceMap = new ServiceMap();
	private final AnchorChangeListener anchorChangeNotifier;
	
	// display
	private ContentConstants displayConstants;
	
	// message listener
	private IMessageListener messageListener;
	
	// widgets
	private Table<Long, TitleRecord> assetTable;
	private UiAssetTableDataProvider dp;
	private ButtonWidget goButton;
	private ButtonWidget cancelButton;
	private ListBoxWidget<String> actionsListBox;
	private ListBoxWidget<String> parameterListBox;
	private ListBoxWidget<String> multiSelectParameterListBox;
	private HorizontalContainer actionListContainer, cancelContainer;
	private LabelWidget countWidget;
	
	private SimpleContainer parentContainer;
	private SearchResultsPanel searchResultsPanel;

	private CookieStoreBasedPageFeatureImpl pageFeature;
	
	/* The Anchors */
	public static final String RESULTS_PAGE_ANCHOR = "Results";
	
	TitleListButtonClickListener actionButtonHandler = null;
	boolean useMultiSelectParameters=false;
	

	private List<UiColumn> displayColumns;
	private UiColumn sortColumn;
	private UISortOrder sortOrder;
	
	private boolean isSeries = false;
	
	private ContentMessages messages = (ContentMessages) GWT.create(ContentMessages.class);
	
	public TitleListPanel(AnchorChangeListener anchorChangeNotifier,
			UITitleFilter titleFilter, TitleListViewInput viewInput,
			Long requestKey, String action, String listOfAssetIds,
			String infoMessage, boolean isQuickSearch, boolean isSeries,
			ResultsLoadedHandler loadHandler, List<UiColumn> displayColumns,
			UiColumn selectedSortColumn, UISortOrder selectedSortOrder, 
			SimpleContainer searchResultsPanelWrapper) {
		/* Not a good way to do this, but not enough control available */
		showBusyIndicator();

		displayConstants = (ContentConstants) GWT.create(ContentConstants.class);

		this.security = NeptuneApplication.getApplication().getSecurity();
		this.titleFilter = titleFilter;
		this.serviceLoader = NeptuneApplication.getApplication().getServiceLoader();
		this.anchorChangeNotifier = anchorChangeNotifier;
		this.input = viewInput;
		this.requestKey = requestKey;
		this.action = action;
		this.listOfAssetIds = listOfAssetIds;
		this.displayColumns = displayColumns;
		this.sortColumn = selectedSortColumn;
		this.sortOrder = selectedSortOrder;
		this.isSeries = isSeries;
		this.parentContainer = searchResultsPanelWrapper;
		this.initWidgets();
		this.setWidgets();
		this.initializeDataProvider(infoMessage, isQuickSearch);
		addHandler(loadHandler, ResultsLoadedEvent.TYPE);
		
	}

	@Override
	protected void onUnload() {
		super.onUnload();

		busyIndicator.hide();
	}
	
	private void initWidgets() {
		rootContainer = new SimpleContainer();
		rootContainer.setStylePrimaryName(STYLE_NAME);
		initWidget(rootContainer);

		container = new VerticalContainer();
		rootContainer.setWidget(container);
		container.setSpacing(SPACING);
		
		// table is added separately

		// actionlist box
		actionsListBox = new ListBoxWidget<String>(false);
		
		// listbox for additional params used by the service 
		parameterListBox = new ListBoxWidget<String>(false);
		parameterListBox.setVisible(false);
		multiSelectParameterListBox = new ListBoxWidget<String>(true);
		multiSelectParameterListBox.setVisible(false);
		
		//cancel button
		cancelButton = new ButtonWidget(displayConstants.cancelButtonName());
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		cancelButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				cancelClickedAction();
			}

			
		});
		// go button
		goButton = new ButtonWidget(displayConstants.goButtonName());
		actionButtonHandler = new TitleListButtonClickListener(actionsListBox, parameterListBox, this, serviceMap);
		goButton.addClickHandler(actionButtonHandler); 
		goButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);

		// populate the action listbox after all dependent widgets are ready
		buildActionsListWidget();
	}

	private void setWidgets() {		
		countWidget = new LabelWidget("");
		if(titleFilter.isCountIncluded()) {
			container.add(countWidget);
		}
	}
	    private void cancelClickedAction() {
	    	anchorChangeNotifier.anchorChanged("");
	       	fireEvent(new ViewCancelEvent());
		}
	   
	    /* Initialize the Data Provider */
	private void initializeDataProvider(final String infoMessage, final boolean isQuickSearch) {
		dp = new UiAssetTableDataProvider(this);
		try {
			SearchResultColumnBuilder columnBuilder = new SearchResultColumnBuilder(this);
			List<Column<?, TitleRecord>> colsWithRecord = columnBuilder.buildRecordForColumns(displayColumns);
			List<Column<?, TitleRecord>> sortCols = columnBuilder.getSortColumns(displayColumns);
			dp.init(displayColumns);
			dp.setDisplayColumns(colsWithRecord);
			dp.setSortColumns(sortCols);

			show(infoMessage);
			if (TitleListPanel.this.input.getTitleListId() != 0) {
				initializeExpandingFeatureTable();
			} else {
				initializeTable(null);
			}

		} catch (Throwable t) {
			hideBusyIndicator();
			Window.alert("Failed to initialize Asset Table Data Provider. Reason: "
					+ ((t != null) ? t.getMessage() : ""));
		}
	}

	    private void initializeExpandingFeatureTable() {
    		SpecificationServiceAsync specService = GWT.create(SpecificationService.class);
    		specService.getTable(TITLE_ASSET_LIST_TABLE, new NeptuneAsyncCallback<UiTable>() {
    			@Override
    			public void onNeptuneFailure(Throwable caught) {
    				Window.alert(caught.getLocalizedMessage());	
    			}
    
    			@Override
    			public void onNeptuneSuccess(UiTable table) {
    				initializeTable(table);
    			}
    		});
    	}

	    /* Initialize the Table */
	    private void initializeTable( UiTable table ) {
			TitleListExpandingProvider titleListExpandingProvider = null;
			ExpandingFeatureImpl<Long, TitleRecord, Long, AssetRecord> expandingFeature = null;
	
			if ( table != null ) {
			    titleListExpandingProvider = new TitleListExpandingProvider( table );
			    expandingFeature = new ExpandingFeatureImpl<Long, TitleRecord, Long, AssetRecord>(
				    titleListExpandingProvider);
			}
	
			// build title table
			assetTable = new Table<Long, TitleRecord>(dp, expandingFeature);
			pageFeature = new CookieStoreBasedPageFeatureImpl("titleList", false);
			dp.setPageFeature(pageFeature);
			Column<?, TitleRecord> sc = null; 
			for(Column<?, TitleRecord> record : dp.getSortableColumns()) {
				if(record.getDisplayName().equals(this.sortColumn.getDisplayName())) {
					sc = record;
					break;
				}
			}
			SortOrder order = SortOrder.valueOf(this.sortOrder.name());
			SortFeatureImpl<Long, TitleRecord> sortFeature = new SortFeatureImpl<Long, TitleRecord>(sc, order);
			
			for (Column<?, TitleRecord> sortableCol : dp.getSortableColumns())
			    sortFeature.addSortableColumn(sortableCol);
			dp.setSortFeature(sortFeature);
	
			assetTable.addPageFeature(pageFeature);
			assetTable.addSortFeature(sortFeature);
			
			// add asset table to this container
			container.add(assetTable);
			
			if (titleListExpandingProvider != null) {
			    titleListExpandingProvider.setTable(assetTable);
			}
	
			// init the table asynchronously
			assetTable.initialize(new NeptuneAsyncCallback<Void>() {
			    @Override
			    public void onNeptuneFailure(Throwable caught) {
				hideBusyIndicator();
			    }
	
			    @Override
			    public void onNeptuneSuccess(Void result) {
				assetTable.refresh();
			    }
			});
	    }

	private void buildActionsListWidget() {
		actionListContainer = new HorizontalContainer();
		cancelContainer = new HorizontalContainer();
		//add action items to actions listbox
		ActionListDataProvider<ITitleService> listItemProvider = new ActionListDataProvider<ITitleService>(
				ITitleService.class, serviceLoader, isSeries);
		for (UiServiceItem item : listItemProvider.getItems(serviceMap)) {
			actionsListBox.addItem(item.getName(), item.getClassName());
		}
		actionsListBox.setSelectedIndex(listItemProvider.getSelectedItemIndex(serviceMap, this.input));
		String displayName = actionsListBox.getItemText(actionsListBox.getSelectedIndex());
		if(displayName.trim().isEmpty()) {
			setWidgetsForNoAction();
		}
		
		// show parameter list corresponding to the selected service
		final TitleListPanel instance = this;
		actionsListBox.addChangeHandler(new ChangeHandler() {
			public void onChange(ChangeEvent event) {
				// Don't show the parameter list box and go button until the parameters have 
				// been retrieved.
				parameterListBox.setVisible(false);
				multiSelectParameterListBox.setVisible(false);
				goButton.setEnabled(false);
				
				int selectedIndex = actionsListBox.getSelectedIndex();
				String displayName = actionsListBox.getItemText(selectedIndex);
				// if no action is selected, clear out the state
				if(displayName.trim().isEmpty()) {
					setWidgetsForNoAction();
					return;
				}
				
				ITitleActionService selectedAction = serviceMap.getService(displayName);
				//For now, only "Target Sites" use multiselect for the parameters. In future, it is better to refactor
				//by adding new method on ITitleActionService to indicate this multiselect requirement.
				if (selectedAction.getName().equals(displayConstants.runTargetSitesServiceName()) == true ){
					useMultiSelectParameters=true;
					actionButtonHandler.setParameterList(multiSelectParameterListBox);
				}
				else {
					useMultiSelectParameters=false;
					actionButtonHandler.setParameterList(parameterListBox);
				}
				selectedAction.getServiceParameters(new NeptuneAsyncCallback<List<String>>() {
					public void onNeptuneFailure(Throwable caught) {
						// In case of an exception at the very least show the Go button for any 
						// other operation.
						parameterListBox.setVisible(false);
						multiSelectParameterListBox.setVisible(false);
						instance.reportFailure(caught);
					}

					public void onNeptuneSuccess(List<String> result) {
						// Only if there are any parameters for this service, show them and 
						// also enable the GO button
						if (result != null) {
							if (useMultiSelectParameters == false) {
								setParameterList(parameterListBox, result);
								parameterListBox.setVisible(true);
								multiSelectParameterListBox.setVisible(false);
							}
							else {
								setParameterList(multiSelectParameterListBox, result);
								parameterListBox.setVisible(false);								
								multiSelectParameterListBox.setVisible(true);
							}
						}
						goButton.setEnabled(true);
					}
				});
			}

			// TODO List<String> parameters can be changed to List<Object> parameters
			private void setParameterList(ListBoxWidget<String> listBox, List<String> parameters) {
				listBox.clear();
				for (String p : parameters) {
					String name = p;
					String value = p;
					if ((p != null) && (p.contains(RunNormalizationRuleService.SERVICE_PARAM_SEPARATOR))) {
						String[] pArray = p.split(RunNormalizationRuleService.SERVICE_PARAM_SEPARATOR);
						if (pArray.length > 0) {
							name = pArray[0];
						}
						if (pArray.length > 1) {
							value = pArray[1];
						}
					}
					listBox.addItem(name, value);
				}
			}
		});
		cancelContainer.add(cancelButton);
		//add actions listbox to container
		actionListContainer.add(actionsListBox);
		
		//add service parameters to the container.
		actionListContainer.add(parameterListBox);
		actionListContainer.add(multiSelectParameterListBox);
		
		//add GO Button to container
		actionListContainer.add(goButton);
		
		
	}

	private void setWidgetsForNoAction() {
		actionsListBox.setSelectedItem("");
		parameterListBox.clear();
		parameterListBox.setVisible(false);
		goButton.setEnabled(false);
		cancelButton.setEnabled(true);
	}

	/**
	 * @return the security
	 */
	public NeptuneSecurity getSecurity() {
		return security;
	}

	/**
	 * @return the specificationName
	 */
	public String getSpecificationName() {
		return specificationName;
	}

	/**
	 * @return the serviceLoader
	 */
	public ServiceLoader getServiceLoader() {
		return serviceLoader;
	}

	/**
	 * @return the titleFilter
	 */
	public UITitleFilter getTitleFilter() {
		return titleFilter;
	}

	/**
	 * @param titleFilter
	 *            the titleFilter to set
	 */
	public void setTitleFilter(UITitleFilter titleFilter) {
		this.titleFilter = titleFilter;
	}

	/**
	 * @return the assetTable
	 */
	public Table<Long, TitleRecord> getAssetTable() {
		return assetTable;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seecom.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#
	 * getParentContainer()
	 */
	public Widget getParentContainer() {
		return this.getParent();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#reportFailure
	 * (java.lang.Throwable)
	 */
	public void reportFailure(Throwable caught) {
		// show the error message along with the current state
		showErrorMessage(caught.getMessage());
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#cleanup()
	 */
	public void cleanup() {
		this.input.resetInfo();
		this.countWidget.setText("");
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#refresh(java.lang.String)
	 */
	public void refresh(String infoMessage) {
		/* Return to the first page and show the updated list view of the table */
		this.assetTable.getPageFeature().setPageNumber(1);
		this.assetTable.showListView();
		this.assetTable.refresh();
		this.countWidget.setText("");
		rootContainer.setWidget(container);

		parentContainer.setWidget(searchResultsPanel);

		this.show(infoMessage);

		if (anchorChangeNotifier != null)
			anchorChangeNotifier.anchorChanged(RESULTS_PAGE_ANCHOR);
		
		setWidgetsForNoAction();
	}
	
	
	@Override
	public HandlerRegistration addViewCancelHandler(ViewCancelHandler handler) {
		return addHandler(handler, ViewCancelEvent.getType());
	}

	/*
	 * Show the title details for a the selected title 
	 */
	public void showTitleDetails(long titleId) {
		TitleViewInput viewInput = new TitleViewInput(titleId, getRequestKey(), getAction(), getListOfAssetIds());
		TitleView titleView;
		if (isSeries)
			titleView = new SeriesTitleView(viewInput);
		else
			titleView = new TitleView(viewInput);
		/* Listen for anchor changes */
		titleView.addViewAnchorChangeHandler(new ViewAnchorChangeHandler() {
			@Override
			public void onAnchorChange(ViewAnchorChangeEvent event) {
				if (anchorChangeNotifier != null) {
					anchorChangeNotifier.anchorChanged(event.getAnchor());
				}
			}
		});

		/* Listen for view cancel */
		titleView.addViewCancelHandler(new ViewCancelHandler() {
			@Override
			public void onCancel(ViewCancelEvent event) {
				refresh(null);
			}
		});

		parentContainer.setWidget(titleView);
		if (anchorChangeNotifier != null)
			anchorChangeNotifier.anchorChanged(titleView.getAnchor());
	}

	/*
	 * Show the title details for a the selected title 
	 */
	public void showTitleDetails(List<Long> titleIds, long contentClassId) {
		TitleViewInput viewInput = new TitleViewInput(titleIds, contentClassId);
		TitleView titleView = new TitleView(viewInput);

		/* Listen for anchor changes */
		titleView.addViewAnchorChangeHandler(new ViewAnchorChangeHandler() {
			@Override
			public void onAnchorChange(ViewAnchorChangeEvent event) {
				if (anchorChangeNotifier != null) {
					anchorChangeNotifier.anchorChanged(event.getAnchor());
				}
			}
		});

		titleView.addViewCommitHandler(new ViewCommitHandler<TitleViewInput>() {
			@Override
			public void onCommit(ViewCommitEvent<TitleViewInput> event) {
				String message = displayConstants.bulkEditServiceSuccess()
						+ event.getData().getOrderedBulkEditTitleIds();
				refresh(message);
				
			}
			
		});
		/* Listen for view cancel */
		titleView.addViewCancelHandler(new ViewCancelHandler() {
			@Override
			public void onCancel(ViewCancelEvent event) {
				refresh(null);
			}
		});

		parentContainer.setWidget(titleView);
		if (anchorChangeNotifier != null)
			anchorChangeNotifier.anchorChanged(titleView.getAnchor());
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#show(java.lang.String)
	 */
	public void show(String infoMessage) {
		showInfoMessage(infoMessage);
	}
	
	/**
	 * @return the requestKey
	 */
	public Long getRequestKey() {
		return requestKey;
	}

	/**
	 * @param requestKey the requestKey to set
	 */
	public void setRequestKey(Long requestKey) {
		this.requestKey = requestKey;
	}

	/**
	 * @return the action
	 */
	public String getAction() {
		return action;
	}

	/**
	 * @param action the action to set
	 */
	public void setAction(String action) {
		this.action = action;
	}

	/**
	 * @return the listOfAssetIds
	 */
	public String getListOfAssetIds() {
		return listOfAssetIds;
	}

	/**
	 * @param listOfAssetIds the listOfAssetIds to set
	 */
	public void setListOfAssetIds(String listOfAssetIds) {
		this.listOfAssetIds = listOfAssetIds;
	}
	
	/**
	 * @return the input
	 */
	public TitleListViewInput getInput() {
		return input;
	}

	/**
	 * @param viewInput the viewInput to set
	 */
	public void setInput(TitleListViewInput input) {
		this.input = input;
	}

	@Override
	public IActionInput getInputToExecution() {
		return new ActionInput(getSpecificationName(), getInput()
				.getScheduleId(), getInput().getTitleListId(), getInput()
				.getLicenseId(), titleFilter, dp); 
	}

	@Override
	public List<Long> getSeletedRecordIds() {
		List<TitleRecord> selectedIds = getAssetTable().getSelectedRecords();
		List<Long> ids = new ArrayList<Long>();
		for (TitleRecord tr : selectedIds) {
			ids.add(tr.getKey());
		}
		return ids;
	}

	@Override
	public void show(boolean readOnly) {
		this.goButton.setEnabled(readOnly);
		this.cancelButton.setEnabled(readOnly);
		this.actionsListBox.setEnabled(readOnly);
		this.parameterListBox.setEnabled(readOnly);
		this.multiSelectParameterListBox.setEnabled(readOnly);
	}
	
	public boolean hasActions() {
		return actionsListBox.getItemCount() > 0;
	}

    private void showBusyIndicator() {
    	busyIndicator.center();
    }

    public void hideBusyIndicator() {
    	busyIndicator.hide();
    }

	/*
	 * Ideally, use an event from data provider to notify view or use package protected code.
	 */
    public void handleGetRecordsRequest() {
    	showBusyIndicator();
    }
    
    /*
	 * Ideally, use an event from data provider to notify view. This is a 'shortcut'
	 */
    public void handleGetRecordsSuccessResponse(List<TitleRecord> records) {
    	fireEvent(new ResultsLoadedEvent());
		if(titleFilter.isCountIncluded()) {
			countWidget.setText(messages.matchingRecordCount(pageFeature.getRecordCount()));
		}
		hideBusyIndicator();
	}

    /*
     * Ideally, use an event from data provider to notify view. This is a 'shortcut' 
     */
	public void handleGetRecordsFailureResponse(Throwable caught) {
		ResultsLoadedEvent event = new ResultsLoadedEvent(caught);
		fireEvent(event);
		hideBusyIndicator();
	}

	public List<UiColumn> getDisplayColumns() {
		return displayColumns;
	}

	public void setDisplayColumns(List<UiColumn> displayColumns) {
		this.displayColumns = displayColumns;
	}

	public void showInfoMessage(String infoMsg) {
		if (messageListener != null) {
			messageListener.setInfoMessage(infoMsg);
		}
	}
	
	public void showErrorMessage(String errorMessage) {
		if (messageListener != null) {
			messageListener.setErrorMessage(errorMessage);
		}
	}

	public void resetMessagePanel() {
		if (messageListener != null) {
			messageListener.reset();
		}
	}

	/**
	 * @return the anchorChangeNotifier
	 */
	public AnchorChangeListener getAnchorChangeNotifier() {
		return anchorChangeNotifier;
	}

	@Override
	public void registerMessageListener(IMessageListener messageListener) {
		this.messageListener = messageListener;
	}

	/**
	 * @return the searchResultsPanel
	 */
	public SearchResultsPanel getSearchResultsPanel() {
		return searchResultsPanel;
	}

	/**
	 * @param searchResultsPanel the searchResultsPanel to set
	 */
	public void setSearchResultsPanel(SearchResultsPanel searchResultsPanel) {
		this.searchResultsPanel = searchResultsPanel;
	}
	
}
