package com.tandbergtv.cms.portal.content.client.tab.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;

public class TitleListPanelHeader extends SimplePanel {
	private static final String STYLE_HEADER_LABEL = "nwt-HeaderPanel-label";
	private TitleViewMessages messages = GWT.create(TitleViewMessages.class);
	private VerticalPanel mainPanel = new VerticalPanel();
	private HorizontalPanel container;
	private Label label;

	public TitleListPanelHeader(boolean isSeries) {
		container = new HorizontalPanel();
		container.setVerticalAlignment(HorizontalPanel.ALIGN_MIDDLE);
		container.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
		container.setSpacing(4);

		/* Wrap the header panel table in a 'div' to avoid issues with margin on table */
		mainPanel.add(container);

		if(isSeries) {
			label = new Label(messages.seriesTitleList());	
		} else {
			label = new Label(messages.titleList());
		}
		
		label.setStyleName(STYLE_HEADER_LABEL);
		container.add(label);
		
		HTMLWidget hr = new HTMLWidget(
				"<HR style=\"height: 1px; background-color: black; color: black;\" />");
		mainPanel.add(hr);
		mainPanel.setWidth("100%");
		setWidget(mainPanel);
		
	}
}
