package com.tandbergtv.cms.portal.content.client.tab.list.actionlist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.tandbergtv.cms.portal.content.client.model.UiServiceItem;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;

/**
 * Class that gets the items that should be put into the action list box in the
 * list ui page
 * 
 * @author spuranik
 * 
 */
public class ActionListDataProvider<S extends ITitleActionService> {
	private ServiceLoader serviceLoader;
	private Class<S> serviceClass;
	private boolean isSeries;
	private boolean isMultipleUpdate;
	private boolean isSiteTitle;
	List<UiServiceItem> items;

	public ActionListDataProvider(Class<S> serviceClass, ServiceLoader serviceLoader, boolean isSeries) {
		this(serviceClass, serviceLoader, isSeries, true, false);
	}

	public ActionListDataProvider(Class<S> serviceClass, ServiceLoader serviceLoader, boolean isSeries,
		boolean isMultipleUpdate, boolean isSiteTitle) {

		this.serviceLoader = serviceLoader;
		this.serviceClass = serviceClass;
		this.isSeries = isSeries;
		this.isMultipleUpdate = isMultipleUpdate;
		this.isSiteTitle = isSiteTitle;
		items = new ArrayList<UiServiceItem>();
	}

	/**
	 * Returns a list of service info that will be used by the UI. It also
	 * populates the service map with the service instances which can be looked
	 * up at a later time.
	 * 
	 * @return
	 */
	public List<UiServiceItem> getItems(ServiceMap map) {
		List<S> titleServices = serviceLoader.loadServices(serviceClass);
		// default blank entry
		items.add(new UiServiceItem("", "", ""));

		for (S service : titleServices) {
			ITitleActionService s = service;
			Map<String, String> serviceActionParameters = s.getServiceActionParameters();
			
			String titleType = serviceActionParameters.get("TITLE_TYPE");
			String updateType = serviceActionParameters.get("UPDATE_TYPE");

			if (titleType == null || updateType == null) {
				continue;
			} else if (isMultipleUpdate && !updateType.contains("MULTIPLE")) {
				continue;
			} else if (!isMultipleUpdate && !updateType.contains("SINGLE")) {
				continue;
			} else if (isSeries && !titleType.contains("SERIES")) {
				continue;
			} else if (isSiteTitle && !titleType.contains("SITE")) {
				continue;
			} else if (!isSeries && !isSiteTitle && !titleType.contains("MASTER")) {
				continue;
			}

			items.add(new UiServiceItem(s.getName(), s.getDescription(), s.getClass().getName()));
			map.put(s.getName(), s);
		}
			

		return items;
	}

	/**
	 * Queries all service impls in the map(name->impl) if it should be selected
	 * given the input data. Note: the first one to respond back is used as the
	 * selected item.
	 * 
	 * @param map
	 * @param inputData
	 * @return
	 */
	public int getSelectedItemIndex(ServiceMap map, ViewInput inputData) {
		for(int i=0; i < map.listAllServices().size();i++){
			ITitleActionService service = map.listAllServices().get(i); 
			if(service.isSelected(inputData)) {
				return getUiItemIndex(service); 
			}
		}
		// If nothing matched, select the first item.
		return 0;
	}
	
	/**
	 * Finds the index of the matching uiservice object for the given service.
	 * 
	 * @param service
	 * @return
	 */
	private int getUiItemIndex(ITitleActionService service) {
		for (int i=0; i < items.size(); i++) {
			UiServiceItem item = items.get(i); 
			if(item.getName().equalsIgnoreCase(service.getName())) {
				return i;
			}
		}
		// If nothing matched, select the first item.
		return 0;
	}
}
