package com.tandbergtv.cms.portal.content.client.tab.list.actionlist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;

/**
 * Class that keeps a list of all service implementations for IUiService. This
 * is done so that the correct class can be picked up at run time.
 * 
 * @author spuranik
 * 
 */
public class ServiceMap {

	private Map<String, ITitleActionService> serviceImplMap = new HashMap<String, ITitleActionService>();

	public void put(String name, ITitleActionService service) {
		serviceImplMap.put(name, service);
	}

	public ITitleActionService getService(String name) {
		return serviceImplMap.get(name);
	}

	public void removeService(String name) {
		serviceImplMap.remove(name);
	}
	
	public List<ITitleActionService> listAllServices() {
		List<ITitleActionService> services = new ArrayList<ITitleActionService>();
		services.addAll(serviceImplMap.values());
		return services;
	}
}
